﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core
{
    using ToolDevelopmentKit;

    /// <summary>
    /// オブジェクトのインスタンス生成処理を委譲するオブジェクトファクトリです。
    /// </summary>
    /// <typeparam name="TParam">パラメータの型を指定します。</typeparam>
    /// <typeparam name="TValue">生成するオブジェクトの型を指定します。</typeparam>
    public class ObjectFactoryDelegation<TParam, TValue> : IObjectFactory<TParam, TValue>
    {
        /// <summary>
        /// オブジェクトのインスタンスを生成します。
        /// </summary>
        /// <param name="param">パラメータを指定します。</param>
        /// <returns>生成したオブジェクトのインスタンスを返します。</returns>
        public delegate TValue CreateHandler(TParam param);

        private CreateHandler handler;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="handler">オブジェクトのインスタンス生成ハンドラを指定します。</param>
        public ObjectFactoryDelegation(CreateHandler handler)
        {
            Ensure.Argument.NotNull(handler);
            this.handler = handler;
        }

        /// <summary>
        /// 指定されたパラメータからオブジェクトのインスタンスを作成します。
        /// </summary>
        /// <param name="param">パラメータを指定します。</param>
        /// <returns>生成したオブジェクトのインスタンスを返します。</returns>
        public virtual TValue Create(TParam param)
        {
            Ensure.Argument.NotNull(param);
            return this.handler(param);
        }
    }
}
