﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System;
    using System.Security.Cryptography;

    /// <summary>
    /// キーとパラメータのコレクションを管理します。
    /// </summary>
    public interface IParameterDictionary
    {
        /// <summary>
        /// パラメータ値が変更されると発生します。
        /// </summary>
        event ParameterEventHandler ParameterValueChanged;

        /// <summary>
        /// パラメータディクショナリに含まれる全てのキーを取得します。
        /// </summary>
        string[] Keys { get; }

        /// <summary>
        /// 指定キーを持つパラメータ値を取得または設定します。
        /// </summary>
        /// <param name="key">キー。</param>
        /// <returns>パラメータ値。</returns>
        IParameterValue this[string key] { get; }

        /// <summary>
        /// 指定キーを持つパラメータが存在するか確認します。
        /// </summary>
        /// <param name="key">キー。</param>
        /// <returns>存在する場合は true、存在しない場合は false。</returns>
        bool ContainsKey(string key);

        /// <summary>
        /// 指定キーを持つパラメータ値を取得します。
        /// </summary>
        /// <param name="key">キー。</param>
        /// <returns>パラメータ値。</returns>
        IParameterValue GetValue(string key);

        /// <summary>
        /// 指定キーを持つパラメータ値を追加します。
        /// </summary>
        /// <param name="key">キー。</param>
        /// <param name="value">パラメータ値。</param>
        void AddValue(string key, IParameterValue value);

        /// <summary>
        /// 指定キーを持つパラメータ値を削除します。
        /// </summary>
        /// <param name="key">キー。</param>
        void RemoveValue(string key);

        /// <summary>
        /// パラメータ辞書のハッシュコードを取得します。
        /// </summary>
        /// <param name="algorithm">ハッシュアルゴリズムを指定します。</param>
        /// <param name="key">パラメータキーを指定します。</param>
        /// <param name="filter">対象パラメータのフィルタを指定します。</param>
        /// <returns>ハッシュコードを返します。</returns>
        HashCode GetParameterDictionaryHashCode(
            HashAlgorithm algorithm,
            string key,
            Func<IParameterValue, bool> filter);
    }
}
