﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System;
    using System.Collections.Generic;
    using System.Security.Cryptography;

    /// <summary>
    /// 読み取り専用のパラメータ値を格納します。
    /// </summary>
    public interface IConstParameterValue
    {
        /// <summary>
        /// パラメータの値を取得または設定します。
        /// </summary>
        object Value { get; }

        /// <summary>
        /// パラメータの属性コレクションを取得します。
        /// </summary>
        ICollection<object> Attributes { get; }

        //-----------------------------------------------------------------

        /// <summary>
        /// パラメータの値からテキストを取得します。
        /// </summary>
        /// <returns>テキストを返します。</returns>
        string ToString();

        /// <summary>
        /// パラメータキーを含めたパラメータのハッシュコードを取得します。
        /// </summary>
        /// <param name="algorithm">ハッシュアルゴリズムを指定します。</param>
        /// <param name="key">パラメータキーを指定します。</param>
        /// <param name="filter">対象パラメータのフィルタを指定します。</param>
        /// <returns>ハッシュコードを返します。</returns>
        HashCode GetParameterHashCode(HashAlgorithm algorithm, string key, Func<IParameterValue, bool> filter);
    }
}
