﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System.Collections.Generic;

    /// <summary>
    /// 出力を管理するインターフェイスです。
    /// </summary>
    public interface IOutput
    {
        /// <summary>
        /// 出力が Dirty かどうかを調べます。
        /// </summary>
        bool IsDirty { get; }

        /// <summary>
        /// 出力アイテム辞書を取得します。
        /// </summary>
        IDictionary<string, IOutputItem> ItemDictionary { get; }

        /// <summary>
        /// 依存ファイルパスの列挙子を取得します。
        /// </summary>
        IEnumerable<string> DependentFilePaths { get; }
    }
}
