﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// コンテントを処理する機能を提供します。
    /// </summary>
    public interface IConversionProcessor
    {
        /// <summary>
        /// IConversionProcessor の状態が変更されると発生します。
        /// </summary>
        event EventHandler<ConversionProcessStateEventArgs> StateChanged;

        /// <summary>
        /// 依存する IConversionProcessor のリストを取得します。
        /// </summary>
        IList<IConversionProcessor> Dependencies { get; }

        /// <summary>
        /// IConversionProcessor の状態を取得します。
        /// </summary>
        ConversionProcessState State { get; }

        /// <summary>
        /// 強制的に実行するかどうかを取得または設定します。
        /// </summary>
        bool IsForced { get; set; }

        /// <summary>
        /// 処理をスキップしたかどうかを取得または設定します。
        /// </summary>
        bool IsSkiped { get; set; }

        /// <summary>
        /// コンテントに対する処理を実行します。
        /// </summary>
        /// <param name="context">コンテキストを指定します。</param>
        void Run(ConversionContext context);
    }
}
