﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System;
    using System.Diagnostics;

    internal static class ColumnSortTypeEx
    {
        public static string ToText(this ColumnSortType value)
        {
            switch (value)
            {
                case ColumnSortType.Number:
                    return "Number";

                case ColumnSortType.String:
                    return "String";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static ColumnSortType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Number":
                    return ColumnSortType.Number;

                case "String":
                    return ColumnSortType.String;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
