﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using ToolDevelopmentKit;

    /// <summary>
    /// バンクレポートの特性を管理します。
    /// </summary>
    public class BankReportTraits : ReportTraits
    {
        public static class ColumnName
        {
            public const string Comment = "Comment";
            public const string EnvelopeAttack = "Envelope/Attack";
            public const string EnvelopeDecay = "Envelope/Decay";
            public const string EnvelopeHold = "Envelope/Hold";
            public const string EnvelopeRelease = "Envelope/Release";
            public const string EnvelopeSustain = "Envelope/Sustain";
            public const string FileName = "FileName";
            public const string ItemIndex = "ItemIndex";
            public const string Name = "Name";
            public const string OriginalKey = "OriginalKey";
            public const string PitchSemitones = "PitchSemitones";
            public const string PitchCents = "PitchCents";
            public const string ProgramNo = "ProgramNo";
            public const string Volume = "Volume";
            public const string WaveEncoding = "WaveEncoding";

            public const string WaveTime = "WaveTime";
            public const string WaveTick = "WaveTick";
            public const string SampleRate = "SampleRate";
            public const string WaveBitRate = "WaveBitRate";
            public const string WaveSampleBit = "WaveSampleBit";
            public const string InterpolationType = "InterpolationType";
        }

        protected override void InitializeColumns(IDictionary<string, Column> columns)
        {
            Assertion.Argument.NotNull(columns);

            columns.Add(
                ColumnName.Comment,
                new Column(ColumnName.Comment, "Comment", ColumnSortType.String));
            columns.Add(
                ColumnName.EnvelopeAttack,
                new Column(ColumnName.EnvelopeAttack, "EnvA", ColumnSortType.Number));
            columns.Add(
                ColumnName.EnvelopeDecay,
                new Column(ColumnName.EnvelopeDecay, "EnvD", ColumnSortType.Number));
            columns.Add(
                ColumnName.EnvelopeHold,
                new Column(ColumnName.EnvelopeHold, "EnvH", ColumnSortType.Number));
            columns.Add(
                ColumnName.EnvelopeRelease,
                new Column(ColumnName.EnvelopeRelease, "EnvR", ColumnSortType.Number));
            columns.Add(
                ColumnName.EnvelopeSustain,
                new Column(ColumnName.EnvelopeSustain, "EnvS", ColumnSortType.Number));
            columns.Add(
                ColumnName.FileName,
                new Column(ColumnName.FileName, "File Name", ColumnSortType.String));
            columns.Add(
                ColumnName.ItemIndex,
                new Column(ColumnName.ItemIndex, "Index", ColumnSortType.Number));
            columns.Add(
                ColumnName.Name,
                new Column(ColumnName.Name, "Name", ColumnSortType.String));
            columns.Add(
                ColumnName.OriginalKey,
                new Column(ColumnName.OriginalKey, "Original Key", ColumnSortType.Number));
            columns.Add(
                ColumnName.PitchSemitones,
                new Column(ColumnName.PitchSemitones, "Pitch (Semitones)", ColumnSortType.Number));
            columns.Add(
                ColumnName.PitchCents,
                new Column(ColumnName.PitchCents, "Pitch (Cents)", ColumnSortType.Number));
            columns.Add(
                ColumnName.ProgramNo,
                new Column(ColumnName.ProgramNo, "Program", ColumnSortType.Number));
            columns.Add(
                ColumnName.Volume,
                new Column(ColumnName.Volume, "Volume", ColumnSortType.Number));
            columns.Add(
                ColumnName.WaveEncoding,
                new Column(ColumnName.WaveEncoding, "Compression Format", ColumnSortType.String));

            columns.Add(
                ColumnName.WaveTime,
                new Column(ColumnName.WaveTime, "WaveTime", ColumnSortType.Number));
            columns.Add(
                ColumnName.WaveTick,
                new Column(ColumnName.WaveTick, "WaveTick", ColumnSortType.Number));
            columns.Add(
                ColumnName.SampleRate,
                new Column(ColumnName.SampleRate, "SampleRate", ColumnSortType.Number));
            columns.Add(
                ColumnName.WaveBitRate,
                new Column(ColumnName.WaveBitRate, "WaveBitRate", ColumnSortType.Number));
            columns.Add(
                ColumnName.WaveSampleBit,
                new Column(ColumnName.WaveSampleBit, "WaveSampleBit", ColumnSortType.Number));
            columns.Add(
                ColumnName.InterpolationType,
                new Column(ColumnName.InterpolationType, "InterpolationType", ColumnSortType.Number));
        }
    }
}
