﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ストリーム情報を格納します。
    /// </summary>
    public struct WaveStreamInformation
    {
        private readonly int length;
        private readonly int frameCount;
        private readonly WaveFormat format;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="format">波形のフォーマットを指定します。</param>
        public WaveStreamInformation(WaveFormat format)
            : this(0, 0, format)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="length">ストリームの長さを指定します。</param>
        /// <param name="frameCount">ストリームに含まれるフレーム数を指定します。</param>
        /// <param name="format">波形のフォーマットを指定します。</param>
        public WaveStreamInformation(int length, int frameCount, WaveFormat format)
        {
            Ensure.Argument.True(length >= 0);
            Ensure.Argument.True(frameCount >= 0);
            this.length = length;
            this.frameCount = frameCount;
            this.format = format;
        }

        /// <summary>
        /// ストリームの長さを取得します。
        /// </summary>
        /// <remarks>ストリームの長さが不明な場合は 0 を返します。</remarks>
        public int Length
        {
            get { return this.length; }
        }

        /// <summary>
        /// ストリームに含まれるフレーム数を取得します。
        /// </summary>
        /// <remarks>フレーム数が不明な場合は 0 を返します。</remarks>
        public int FrameCount
        {
            get { return this.frameCount; }
        }

        /// <summary>
        /// 波形のフォーマットを返します。
        /// </summary>
        public WaveFormat Format
        {
            get { return this.format; }
        }
    }
}
