﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using System.IO;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 波形ストリームクラスです。
    /// </summary>
    public class WaveStream : IDisposable
    {
        private readonly WaveFormat format;
        private readonly Stream payload;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="format">波形のフォーマットを指定します。</param>
        /// <param name="payload">波形ペイロードのストリームを指定します。</param>
        public WaveStream(WaveFormat format, Stream payload)
        {
            Ensure.Argument.NotNull(format);
            Ensure.Argument.NotNull(payload);
            this.format = format;
            this.payload = payload;
        }

        /// <summary>
        /// 波形のフォーマットを取得します。
        /// </summary>
        public WaveFormat Format
        {
            get { return this.format; }
        }

        /// <summary>
        /// 波形のペイロードを取得します。
        /// </summary>
        public Stream Payload
        {
            get { return this.payload; }
        }

        public void Dispose()
        {
            this.payload.Dispose();
        }
    }
}
