﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// パケットイベントのデータを格納します。
    /// </summary>
    public class PacketEventArgs : EventArgs
    {
        private Packet packet;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="packet">パケットを指定します。</param>
        public PacketEventArgs(Packet packet)
        {
            Ensure.Argument.NotNull(packet);
            this.packet = packet;
        }

        /// <summary>
        /// パケットを取得します。
        /// </summary>
        public Packet Packet
        {
            get { return this.packet; }
        }
    }
}
