﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using System.IO;

    public class DomWriterContext : DomContext
    {
        private ObjectWriter objectWriter;
        private ObjectReferenceResolver referenceResolver;

        public DomWriterContext(BinaryWriter writer)
        {
            if (null == writer) { throw new ArgumentNullException("writer"); }
            this.objectWriter = new ObjectWriter(writer);

            this.referenceResolver = new ObjectReferenceResolver(this);
        }

        public ObjectWriter Writer
        {
            get { return this.objectWriter; }
        }

        public ObjectReferenceResolver ReferenceResolver
        {
            get { return this.referenceResolver; }
        }

        public Address CreateAddress(ulong value)
        {
            return new Address((ulong)value);
        }
    }
}
