﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    public class DomObjectWriter : IDomObjectProcessor
    {
        private ITypeConverter typeConverter;

        public DomObjectWriter()
        {
        }

        public DomObjectWriter(ITypeConverter typeConverter)
        {
            this.typeConverter = typeConverter;
        }

        public void Run(DomObject domObject, IDomContext context)
        {
            if (null == domObject) { throw new ArgumentNullException("obj"); }
            if (null == context) { throw new ArgumentNullException("context"); }

            // DomElement はスキップします。
            // DomElementField を処理すれば OK です。
            if (domObject is DomElement) { return; }

            DomWriterContext writerContext = context as DomWriterContext;
            if (null == writerContext)
            {
                throw new ArgumentException("objectProcessor must be DomWriterContext.");
            }

            object value = domObject.Value;

            if (this.typeConverter != null)
            {
                value = this.typeConverter.ConvertTo(domObject.Value);
            }

            writerContext.Writer.Write(value);
        }
    }
}
