﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;
using System.Collections.Generic;

namespace NintendoWare.SoundAdditionalInfoConverter.Binaries
{
    internal class StreamJumpDataBinary
    {
        internal StreamJumpDataBinary()
        {
            this.Header = new BinaryHeader();
            this.Orders = new List<int>();
        }

        internal BinaryHeader Header { get; set; }

        internal int OrderCount { get; set; }

        internal List<int> Orders { get; set; }

        internal int FileSize { get; set; }

        internal string GetExtension()
        {
            return ".bnstj";
        }

        internal bool Output(BinaryWriter writer)
        {
            this.Header.Signature = "BNSTJ   ";
            this.Header.OffsetToBody = (short)this.Header.GetSize();
            this.Header.FileSize = this.FileSize + this.Header.GetSize();
            this.Header.Output(writer);

            writer.Write(this.OrderCount);
            foreach (var order in this.Orders)
            {
                writer.Write(order);
            }

            return true;
        }
    }
}
