﻿namespace Opal.Windows
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;

    /// <summary>
    /// ウィンドウ作成抽象クラスです。
    /// </summary>
    public abstract class WindowMaker
    {
        private readonly Type windowType;
        private readonly bool isModal;
        private Window ownerWindow = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="windowType">ウィンドウのタイプです。</param>
        /// <param name="isModal">true の場合はモーダルウィンドウとして表示します。</param>
        protected WindowMaker(Type windowType, bool isModal)
        {
            this.windowType = windowType;
            this.isModal = isModal;
        }

        /// <summary>
        /// ウィンドウタイプを取得します。
        /// </summary>
        internal Type WindowType
        {
            get
            {
                return this.windowType;
            }
        }

        /// <summary>
        /// オーナーウィンドウを取得設定します。
        /// </summary>
        protected Window OwnerWindow
        {
            get
            {
                return this.ownerWindow;
            }

            set
            {
                this.ownerWindow = value;
            }
        }

        /// <summary>
        /// モーダル状態を取得します。
        /// </summary>
        protected bool IsModal
        {
            get
            {
                return this.isModal;
            }
        }

        /// <summary>
        /// ウィンドウを表示します。
        /// </summary>
        /// <returns>表示結果を返します。</returns>
        public virtual bool Show()
        {
            return false;
        }
    }
}
