﻿namespace Opal.Windows.Generic
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;

    /// <summary>
    /// ジェネリック版のウィンドウ作成抽象クラスです。
    /// </summary>
    /// <typeparam name="TArgs">ウィンドウ表示の引数クラスのテンプレートの型です。</typeparam>
    public abstract class WindowMaker<TArgs> : WindowMaker
        where TArgs : WindowArgs
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="windowType">ウィンドウのタイプです。</param>
        protected WindowMaker(Type windowType)
            : base(windowType, true)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="windowType">ウィンドウのタイプです。</param>
        /// <param name="isModal">true の場合はモーダルウィンドウとして表示します。</param>
        protected WindowMaker(Type windowType, bool isModal)
            : base(windowType, isModal)
        {
        }

        /// <summary>
        /// ウィンドウを表示します。
        /// </summary>
        /// <returns>表示結果を返します。</returns>
        public override bool Show()
        {
            return this.Show(null);
        }

        /// <summary>
        /// ウィンドウを表示します。
        /// </summary>
        /// <param name="args">表示用の引数クラスです。</param>
        /// <returns>表示結果を返します。</returns>
        internal bool Show(TArgs args)
        {
            var window = this.CreateWindow(args);
            Debug.Assert(window != null);

            // オーナーウィンドウの設定と表示位置をオーナーの中心に設定
            window.Owner = this.OwnerWindow;
            window.WindowStartupLocation = WindowStartupLocation.CenterOwner;

            if (this.IsModal)
            {
                bool? result = window.ShowDialog();

                if (window.DataContext != null)
                {
                    window.DataContext = null;
                }

                if (result.HasValue)
                {
                    return (bool)result;
                }
            }
            else
            {
                window.Show();
            }

            return true;
        }

        /// <summary>
        /// ウィンドウを作成します。
        /// </summary>
        /// <param name="args">ウィンドウ表示の引数クラスです。</param>
        /// <returns>ウィンドウのインスタンスを返します。</returns>
        protected abstract Window CreateWindow(TArgs args);
    }
}
