﻿namespace Opal.Windows.Data
{
    using System;
    using System.Collections.Generic;
    using System.Globalization;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;
    using Opal.ViewModels;

    /// <summary>
    /// アクティブなドキュメントの値を変換するクラスです。
    /// </summary>
    public sealed class ActiveDocumentConverter : IValueConverter
    {
        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">バインディングソースによって生成される値です。</param>
        /// <param name="targetType">バインディングターゲットのプロパティの値です。</param>
        /// <param name="parameter">使用するコンバーターパラメーターです。</param>
        /// <param name="culture">コンバーターで使用するカルチャです。</param>
        /// <returns>変換された値を返します。</returns>
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is DocumentViewModel)
            {
                return value;
            }

            return Binding.DoNothing;
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">バインディングターゲットによって生成される値です。</param>
        /// <param name="targetType">変換後の型です。</param>
        /// <param name="parameter">使用するコンバーターパラメーターです。</param>
        /// <param name="culture">コンバーターで使用するカルチャです。</param>
        /// <returns>変換された値を返します。</returns>
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is DocumentViewModel)
            {
                return value;
            }

            return Binding.DoNothing;
        }
    }
}
