﻿namespace Opal.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Services;

    /// <summary>
    /// ドキュメントを閉じる時に実行されるイベント引数クラスです。
    /// </summary>
    internal class DocumentClosedEventArgs : EventArgs
    {
        private readonly WeakReference<IDocument> weakDocument;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="document">閉じる対象のドキュメントです。</param>
        internal DocumentClosedEventArgs(IDocument document)
        {
            this.weakDocument = new WeakReference<IDocument>(document);
        }

        /// <summary>
        /// 弱参照のドキュメントを取得します。
        /// </summary>
        internal WeakReference<IDocument> WeakDocument
        {
            get
            {
                return this.weakDocument;
            }
        }
    }
}
