﻿namespace Opal.Panes
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;
    using Opal.ViewModels;

    /// <summary>
    /// ペイン管理インターフェースです。
    /// </summary>
    public interface IPaneManager : IAnyManager
    {
        /// <summary>
        /// ドキュメントを取得します。
        /// </summary>
        /// <returns>ドキュメントのインスタンスを返します。</returns>
        ICollectionView GetDocuments();

        /// <summary>
        /// ツールを取得します。
        /// </summary>
        /// <returns>ツールのインスタンスを返します。</returns>
        ICollectionView GetTools();
#if false
        /// <summary>
        /// ドキュメントを追加します。
        /// </summary>
        /// <param name="viewModel">追加するドキュメントです。</param>
        void AddDocument(DocumentViewModel viewModel);

        /// <summary>
        /// ツールを追加します。
        /// </summary>
        /// <param name="viewModel">追加するツールです。</param>
        void AddTool(ToolViewModel viewModel);

        /// <summary>
        /// ドキュメントを削除します。
        /// </summary>
        /// <param name="viewModel">削除するドキュメントです。</param>
        void RemoveDocument(DocumentViewModel viewModel);

        /// <summary>
        /// ツールを削除します。
        /// </summary>
        /// <param name="viewModel">削除するツールです。</param>
        void RemoveTool(ToolViewModel viewModel);
#endif
        /// <summary>
        /// 指定ドキュメントを含んでいるか判定します。
        /// </summary>
        /// <param name="viewModel">判定対象のドキュメントです。</param>
        /// <returns>含んでいる場合は、true を返します。</returns>
        bool ContainDocument(DocumentViewModel viewModel);

        /// <summary>
        /// 指定ツールを含んでいるか判定します。
        /// </summary>
        /// <param name="viewModel">判定対象のツールです。</param>
        /// <returns>含んでいる場合は、true を返します。</returns>
        bool ContainTool(ToolViewModel viewModel);
    }
}
