﻿namespace Opal.Menus
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Input;
    using Opal.Commands;
    using Opal.ComponentModel;
    using Opal.Plugins;
    using Opal.Utilities;

    /// <summary>
    /// メニュープラグインの基底クラスです。
    /// </summary>
    public abstract class MenuPlugin : Menu, IPlugin
    {
        private int order;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="label">ラベル名です。</param>
        /// <param name="order">メニュの順番です。</param>
        protected MenuPlugin(string label, int order)
            : base(label)
        {
            this.order = order;
        }

        /// <summary>
        /// メニュの順番を返します。
        /// </summary>
        public int Order
        {
            get
            {
                return this.order;
            }
        }
    }
}
