﻿namespace Opal.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// メニュー管理インターフェースです。
    /// </summary>
    public interface IMenuManager : IAnyManager
    {
        /// <summary>
        /// 表示メニューを取得します。
        /// </summary>
        /// <returns>表示メニューのインスタンスを返します。</returns>
        ICollectionView GetDisplayMenus();

        /// <summary>
        /// メニューを取得します。
        /// </summary>
        /// <param name="category">取得対象のメニューの種類です。</param>
        /// <returns>メニューのインスタンスを返します。</returns>
        ICollectionView GetMenus(MenuCategory category);
    }
}
