﻿namespace Opal.Logs
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// ログ処理のベースクラスです。
    /// </summary>
    public abstract class LogConductor
    {
        /// <summary>
        /// ログをフラッシュします。
        /// logs を他に退避して参照し続けないでください。
        /// </summary>
        /// <param name="logs">フラッシュ対象のログです。</param>
        /// <returns>ログ書き込みが成功した場合は、true を返します。</returns>
        public bool FlushLogs(ReadOnlyCollection<Log> logs)
        {
            Debug.Assert(logs != null);
            return this.FlushLogsInternal(logs);
        }

        /// <summary>
        /// ログフラッシュの内部メソッドです。
        /// </summary>
        /// <param name="logs">フラッシュ対象のログです。</param>
        /// <returns>ログ書き込みが成功した場合は、true を返します。</returns>
        protected abstract bool FlushLogsInternal(ReadOnlyCollection<Log> logs);
    }
}
