﻿namespace Opal.Logs
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// コンソール用ログ処理のクラスです。
    /// </summary>
    public sealed class ConsoleLogConductor : LogConductor
    {
        /// <summary>
        /// ログフラッシュの内部メソッドです。
        /// </summary>
        /// <param name="logs">フラッシュ対象のログです。</param>
        /// <returns>ログ書き込みが成功した場合は、true を返します。</returns>
        protected override bool FlushLogsInternal(ReadOnlyCollection<Log> logs)
        {
            foreach (var log in logs)
            {
                Console.Out.WriteLine(log.Message);
                Trace.WriteLine(log.Message);
            }

            return true;
        }
    }
}
