﻿namespace Opal.ComponentModel
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// プロパティ値変更通知イベント引数クラスです。
    /// </summary>
    internal class NotifyPropertyValueChangedEventArgs : EventArgs
    {
        private bool isValueChanged = false;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="changed">値が変更された場合は、true を設定します。</param>
        public NotifyPropertyValueChangedEventArgs(bool changed)
        {
            this.isValueChanged = changed;
        }

        /// <summary>
        /// 値が変更されたか判定します。
        /// </summary>
        public bool IsValueChanged
        {
            get
            {
                return this.isValueChanged;
            }
        }
    }
}
