﻿// ========================================================================
// <copyright file="LayoutUtility.cs" company="Nintendo">
//      Copyright 2013 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace Opal.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.App;
    using Xceed.Wpf.AvalonDock.Layout;
    using Xceed.Wpf.AvalonDock.Layout.Serialization;

    /// <summary>
    /// レイアウトユーティリティクラスです。
    /// </summary>
    public static class LayoutUtility
    {
        /// <summary>
        /// アヴァロンドックのレイアウト設定ファイル名です。
        /// </summary>
        public const string LayoutFile = @".\Opal.AvalonDock.config";

        /// <summary>
        /// アヴァロンドックのレイアウトファイルが存在するか判定します。
        /// </summary>
        /// <returns>存在する場合は、true を返します。</returns>
        public static bool HasAvalonDockLayout()
        {
            return File.Exists(LayoutFile);
        }

        /// <summary>
        /// レイアウトシリアライズ処理です。
        /// </summary>
        /// <param name="sender">送信元です。</param>
        /// <param name="e">イベント引数です。</param>
        public static void CallLayoutSerialization(object sender, LayoutSerializationCallbackEventArgs e)
        {
            if (e.Model is LayoutAnchorable)
            {
                var anchorable = e.Model as LayoutAnchorable;

                // 指定ツールがアドオンに存在する場合のみ処理を続行する。
                var maker = AppManager.GetToolMaker(e.Model.ContentId);
                if (maker != null)
                {
                    var paneManager = AppManager.GetPaneManager();
                    Debug.Assert(paneManager != null);

                    var viewModel = AppManager.AddTool(maker, paneManager);
                    Debug.Assert(viewModel != null);

                    e.Content = viewModel;
                    viewModel.IsVisible = anchorable.IsVisible;
                    viewModel.IsActive = anchorable.IsActive;
                    viewModel.IsSelected = anchorable.IsSelected;
                    return;
                }
                else
                {
                    e.Cancel = true;
                    return;
                }
            }
            else if (e.Model is LayoutDocument)
            {
                // ドキュメントの場合は、シリアライズをキャンセルする。
                var document = e.Model as LayoutDocument;
                e.Cancel = true;
                return;
            }
            else
            {
                e.Cancel = true;
                return;
            }
        }
    }
}
