﻿using Nintendo.G3dTool.Entities;
using Nintendo.ToolFoundation.Contracts;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Extensions
{
    public static class ComponentSelectorExtensions
    {
        public static void FromString(this ComponentSelector target, string source)
        {
            string formatted = source.Replace(" ", string.Empty);
            Ensure.Operation.AreEqual(4, formatted.Length, $"Invalid component selector format: {source}");
            target.R = ConvertToComponentSelectorValue(formatted[0]);
            target.G = ConvertToComponentSelectorValue(formatted[1]);
            target.B = ConvertToComponentSelectorValue(formatted[2]);
            target.A = ConvertToComponentSelectorValue(formatted[3]);
        }

        private static texture_info_comp_selValue ConvertToComponentSelectorValue(char value)
        {
            switch (value)
            {
                case 'r': return texture_info_comp_selValue.r;
                case 'g': return texture_info_comp_selValue.g;
                case 'b': return texture_info_comp_selValue.b;
                case 'a': return texture_info_comp_selValue.a;
                case '0': return texture_info_comp_selValue.Item0;
                case '1': return texture_info_comp_selValue.Item1;
                default:
                    throw new Exception("Unexpected default.");
            }
        }
    }
}
