﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;
namespace Nintendo.G3dTool.Entities{
    public class Int2 : ObservableEntity<string>, IEquatable<Int2>
    {
        private readonly int[] values = new int[2];

        public Int2()
        {
        }

        public Int2(
            int elem0,
            int elem1)
            : this()
        {
            this[0] = elem0;
            this[1] = elem1;
        }

        internal int[] Values
        {
            get
            {
                return this.values;
            }
        }

        public int this[int index]
        {
            get
            {
                Nintendo.ToolFoundation.Contracts.Ensure.Argument.Range(index, 0, 2);
                return this.values[index];
            }

            set
            {
                Nintendo.ToolFoundation.Contracts.Ensure.Argument.Range(index, 0, 2);
                this.SetProperty(ref this.values[index], value, () => this.CalcCRC());
            }
        }



        public int X
        {
            get
            {
                return this.values[0];
            }

            set
            {
                this.SetProperty(ref this.values[0], value, () => this.CalcCRC());
            }
        }

        public int Y
        {
            get
            {
                return this.values[1];
            }

            set
            {
                this.SetProperty(ref this.values[1], value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 比較演算子
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>一致していれば true、そうでなければ false を返します。</returns>
        public bool Equals(Int2 obj)
        {
            if (obj == null)
            {
                return false;
            }

            bool isEqual = true;
            for (int elemIndex = 0; elemIndex < 2; ++elemIndex)
            {
                isEqual &= (obj[elemIndex] == this[elemIndex]);
            }

            return isEqual;
        }

        public override string CreateSerializableData()
        {
            return this.ToString();
        }

        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            return crc.ComputeHashUInt32(this.ToString());
        }

        public override string ToString()
        {
            string result = string.Empty;
            for (int elemIndex = 0; elemIndex < 2; ++elemIndex)
            {
                result += this[elemIndex].ToString() + " ";
            }

            return result.TrimEnd();
        }

        public void DeepCopyFrom(Int2 source)
        {
            for (int elemIndex = 0; elemIndex < 2; ++elemIndex)
            {
                this[elemIndex] = source.Values[elemIndex];
            }
        }

        public static Int2 Parse(string text)
        {
            string[] valueTexts = StringUtility.SplitValueListText(text);
            Int2 result = new Int2();
            for (int elemIndex = 0; elemIndex < 2; ++elemIndex)
            {
                result[elemIndex] = int.Parse(valueTexts[elemIndex]);
            }

            return result;
        }
    }
}
