﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_Type_H__
#define __ShellExtension_Type_H__

// C4351 の警告はコンストラクタ内で配列を初期化する時に表示される。
// この警告は情報として表示されるだけで無視してよいので無効にしておく。
#pragma warning(disable : 4351)


//------------------------------------------------------------------------------
// Texture Type
//------------------------------------------------------------------------------
enum NW_IMG_TYPE
{
    NW_IMG_TYPE_1D,
    NW_IMG_TYPE_2D,
    NW_IMG_TYPE_CUBE,
    NW_IMG_TYPE_3D,
    NW_IMG_TYPE_1D_ARRAY,
    NW_IMG_TYPE_2D_ARRAY,
    NW_IMG_TYPE_3D_ARRAY,
    NW_IMG_TYPE_CUBE_ARRAY,
    NW_IMG_TYPE_NONE
}; // End of NW_IMG_TYPE


//------------------------------------------------------------------------------
// Texture Format
//------------------------------------------------------------------------------
enum NW_IMG_FMT
{
    NW_IMG_FMT_L4,
    NW_IMG_FMT_L8,
    NW_IMG_FMT_A4,
    NW_IMG_FMT_A8,
    NW_IMG_FMT_LA4,
    NW_IMG_FMT_LA8,
    NW_IMG_FMT_HILO8,
    NW_IMG_FMT_RGB565,
    NW_IMG_FMT_RGB8,
    NW_IMG_FMT_RGB5_A1,
    NW_IMG_FMT_RGBA4,
    NW_IMG_FMT_RGBA8,
    NW_IMG_FMT_ETC1,
    NW_IMG_FMT_ETCA,

    // Revolution
    NW_IMG_FMT_R_I4,
    NW_IMG_FMT_R_I8,
    NW_IMG_FMT_R_IA4,
    NW_IMG_FMT_R_IA8,
    NW_IMG_FMT_R_R5G6B5,
    NW_IMG_FMT_R_RGB5A3,
    NW_IMG_FMT_R_RGBA8,
    NW_IMG_FMT_R_C4,
    NW_IMG_FMT_R_C8,
    NW_IMG_FMT_R_C14,
    NW_IMG_FMT_R_CMPR,

    // For Cafe Format
    NW_IMG_FMT_GX2_UNORM_8,
    NW_IMG_FMT_GX2_UINT_8,
    NW_IMG_FMT_GX2_SNORM_8,
    NW_IMG_FMT_GX2_SINT_8,
    NW_IMG_FMT_GX2_UNORM_4_4,
    NW_IMG_FMT_GX2_UNORM_16,
    NW_IMG_FMT_GX2_UINT_16,
    NW_IMG_FMT_GX2_SINT_16,
    NW_IMG_FMT_GX2_FLOAT_16,
    NW_IMG_FMT_GX2_UNORM_8_8,
    NW_IMG_FMT_GX2_UINT_8_8,
    NW_IMG_FMT_GX2_SNORM_8_8,
    NW_IMG_FMT_GX2_SINT_8_8,
    NW_IMG_FMT_GX2_UNORM_5_6_5,
    NW_IMG_FMT_GX2_UNORM_6_5_5,
    NW_IMG_FMT_GX2_SNORM_6_5_5,
    NW_IMG_FMT_GX2_UNORM_1_5_5_5,
    NW_IMG_FMT_GX2_UNORM_4_4_4_4,
    NW_IMG_FMT_GX2_UNORM_5_5_5_1,
    NW_IMG_FMT_GX2_UINT_32,
    NW_IMG_FMT_GX2_SINT_32,
    NW_IMG_FMT_GX2_FLOAT_32,
    NW_IMG_FMT_GX2_UNORM_16_16,
    NW_IMG_FMT_GX2_UINT_16_16,
    NW_IMG_FMT_GX2_SNORM_16_16,
    NW_IMG_FMT_GX2_SINT_16_16,
    NW_IMG_FMT_GX2_FLOAT_16_16,
    NW_IMG_FMT_GX2_FLOAT_11_11_10,
    NW_IMG_FMT_GX2_UNORM_2_10_10_10,
    NW_IMG_FMT_GX2_UNORM_8_8_8_8,
    NW_IMG_FMT_GX2_UINT_8_8_8_8,
    NW_IMG_FMT_GX2_SNORM_8_8_8_8,
    NW_IMG_FMT_GX2_SINT_8_8_8_8,
    NW_IMG_FMT_GX2_SRGB_8_8_8_8,
    NW_IMG_FMT_GX2_UNORM_10_10_10_2,
    NW_IMG_FMT_GX2_UINT_10_10_10_2,
    NW_IMG_FMT_GX2_UINT_32_32,
    NW_IMG_FMT_GX2_SINT_32_32,
    NW_IMG_FMT_GX2_FLOAT_32_32,
    NW_IMG_FMT_GX2_UNORM_16_16_16_16,
    NW_IMG_FMT_GX2_UINT_16_16_16_16,
    NW_IMG_FMT_GX2_SNORM_16_16_16_16,
    NW_IMG_FMT_GX2_SINT_16_16_16_16,
    NW_IMG_FMT_GX2_FLOAT_16_16_16_16,
    NW_IMG_FMT_GX2_UINT_32_32_32_32,
    NW_IMG_FMT_GX2_SINT_32_32_32_32,
    NW_IMG_FMT_GX2_FLOAT_32_32_32_32,
    NW_IMG_FMT_GX2_SHAREDEXP_5_9_9_9,
    NW_IMG_FMT_GX2_UINT_32_32_32,
    NW_IMG_FMT_GX2_SINT_32_32_32,
    NW_IMG_FMT_GX2_FLOAT_32_32_32,
    NW_IMG_FMT_GX2_UNORM_BC1,
    NW_IMG_FMT_GX2_SRGB_BC1,
    NW_IMG_FMT_GX2_UNORM_BC2,
    NW_IMG_FMT_GX2_SRGB_BC2,
    NW_IMG_FMT_GX2_UNORM_BC3,
    NW_IMG_FMT_GX2_SRGB_BC3,
    NW_IMG_FMT_GX2_UNORM_BC4,
    NW_IMG_FMT_GX2_SNORM_BC4,
    NW_IMG_FMT_GX2_UNORM_BC5,
    NW_IMG_FMT_GX2_SNORM_BC5,

    // Cafe より後
    NW_IMG_FMT_UFLOAT_BC6,
    NW_IMG_FMT_FLOAT_BC6,
    NW_IMG_FMT_UNORM_BC7,
    NW_IMG_FMT_SRGB_BC7,
    NW_IMG_FMT_UNORM_ETC1,
    NW_IMG_FMT_UNORM_ETC2,
    NW_IMG_FMT_SRGB_ETC2,
    NW_IMG_FMT_UNORM_ETC2_MASK,
    NW_IMG_FMT_SRGB_ETC2_MASK,
    NW_IMG_FMT_UNORM_ETC2_ALPHA,
    NW_IMG_FMT_SRGB_ETC2_ALPHA,
    NW_IMG_FMT_UNORM_EAC_11,
    NW_IMG_FMT_SNORM_EAC_11,
    NW_IMG_FMT_UNORM_EAC_11_11,
    NW_IMG_FMT_SNORM_EAC_11_11,
    NW_IMG_FMT_UNORM_PVRTC1_2bpp,
    NW_IMG_FMT_SRGB_PVRTC1_2bpp,
    NW_IMG_FMT_UNORM_PVRTC1_4bpp,
    NW_IMG_FMT_SRGB_PVRTC1_4bpp,
    NW_IMG_FMT_UNORM_PVRTC1_ALPHA_2bpp,
    NW_IMG_FMT_SRGB_PVRTC1_ALPHA_2bpp,
    NW_IMG_FMT_UNORM_PVRTC1_ALPHA_4bpp,
    NW_IMG_FMT_SRGB_PVRTC1_ALPHA_4bpp,
    NW_IMG_FMT_UNORM_PVRTC2_ALPHA_2bpp,
    NW_IMG_FMT_SRGB_PVRTC2_ALPHA_2bpp,
    NW_IMG_FMT_UNORM_PVRTC2_ALPHA_4bpp,
    NW_IMG_FMT_SRGB_PVRTC2_ALPHA_4bpp,
    NW_IMG_FMT_UNORM_ASTC_4x4,
    NW_IMG_FMT_SRGB_ASTC_4x4,
    NW_IMG_FMT_UNORM_ASTC_5x4,
    NW_IMG_FMT_SRGB_ASTC_5x4,
    NW_IMG_FMT_UNORM_ASTC_5x5,
    NW_IMG_FMT_SRGB_ASTC_5x5,
    NW_IMG_FMT_UNORM_ASTC_6x5,
    NW_IMG_FMT_SRGB_ASTC_6x5,
    NW_IMG_FMT_UNORM_ASTC_6x6,
    NW_IMG_FMT_SRGB_ASTC_6x6,
    NW_IMG_FMT_UNORM_ASTC_8x5,
    NW_IMG_FMT_SRGB_ASTC_8x5,
    NW_IMG_FMT_UNORM_ASTC_8x6,
    NW_IMG_FMT_SRGB_ASTC_8x6,
    NW_IMG_FMT_UNORM_ASTC_8x8,
    NW_IMG_FMT_SRGB_ASTC_8x8,
    NW_IMG_FMT_UNORM_ASTC_10x5,
    NW_IMG_FMT_SRGB_ASTC_10x5,
    NW_IMG_FMT_UNORM_ASTC_10x6,
    NW_IMG_FMT_SRGB_ASTC_10x6,
    NW_IMG_FMT_UNORM_ASTC_10x8,
    NW_IMG_FMT_SRGB_ASTC_10x8,
    NW_IMG_FMT_UNORM_ASTC_10x10,
    NW_IMG_FMT_SRGB_ASTC_10x10,
    NW_IMG_FMT_UNORM_ASTC_12x10,
    NW_IMG_FMT_SRGB_ASTC_12x10,
    NW_IMG_FMT_UNORM_ASTC_12x12,
    NW_IMG_FMT_SRGB_ASTC_12x12,

    NW_IMG_FMT_SIZE,
    NW_IMG_FMT_NONE
}; // End of NW_IMG_FMT

//------------------------------------------------------------------------------
// TGA type
//------------------------------------------------------------------------------
enum NW_TGA_Type
{
    NW_TGA_NONE = 0,
    NW_TGA_4C,       // CTR
    NW_TGA_4R        // Revolution
};

//------------------------------------------------------------------------------
// Cube Face
//------------------------------------------------------------------------------
enum NW_CUBE_FACE
{
    NW_CUBE_FACE_POS_X,
    NW_CUBE_FACE_NEG_X,
    NW_CUBE_FACE_POS_Y,
    NW_CUBE_FACE_NEG_Y,
    NW_CUBE_FACE_POS_Z,
    NW_CUBE_FACE_NEG_Z
}; // End of NW_CUBE_FACE


//------------------------------------------------------------------------------
// Component selection
//------------------------------------------------------------------------------
enum NW_COMP_SEL_ELEMENT
{
    NW_COMP_SEL_ELEMENT_R,
    NW_COMP_SEL_ELEMENT_G,
    NW_COMP_SEL_ELEMENT_B,
    NW_COMP_SEL_ELEMENT_A,
    NW_COMP_SEL_ELEMENT_0,
    NW_COMP_SEL_ELEMENT_1
}; // End of NW_COMP_SEL_ELEMENT


//------------------------------------------------------------------------------
// Component selection
//------------------------------------------------------------------------------
struct NW_COMP_SEL
{
    NW_COMP_SEL()
    {
        sel[0] = NW_COMP_SEL_ELEMENT_R;
        sel[1] = NW_COMP_SEL_ELEMENT_G;
        sel[2] = NW_COMP_SEL_ELEMENT_B;
        sel[3] = NW_COMP_SEL_ELEMENT_A;
    };

    NW_COMP_SEL_ELEMENT sel[4];
}; // End of NW_COMP_SEL


//------------------------------------------------------------------------------
// Registration Data
//------------------------------------------------------------------------------
struct REGISTRATION_PARAM
{
    std::wstring fileTypeName;
    std::vector<std::wstring> progIDNames;
    std::vector<std::wstring> supportedExtensions;
    std::wstring moduleName;
}; // End of REGISTRATION_PARAM


//------------------------------------------------------------------------------
// Export Setting
//------------------------------------------------------------------------------
struct NW_EXPORT_SETTING
{
    NW_IMG_FMT   format;
    bool         setLinearFlag;
    bool         linearFlag[4];
    int          width;
    int          height;
    bool         hintNormalMap;
    bool         useMipmap;
    int          numMipmaps;
    NW_COMP_SEL  compSel;
    std::wstring comment;
    std::wstring etcEncoding;
    std::wstring hint;

    NW_EXPORT_SETTING() :
        format(NW_IMG_FMT_NONE),
        setLinearFlag(false),
        linearFlag(),
        width(0),
        height(0),
        hintNormalMap(false),
        useMipmap(false),
        numMipmaps(1)
    {
    };

    void CalculateMipmapLevel();
};


//------------------------------------------------------------------------------
// Layer Comps
//------------------------------------------------------------------------------
struct PSD_LAYER_COMPS
{
    std::wstring name;
    NW_EXPORT_SETTING setting;
};

//------------------------------------------------------------------------------
// OriginalImage Format
//------------------------------------------------------------------------------
enum OriginalImageFormat
{
    ORIGINAL_FORMAT_INVALID,
    ORIGINAL_FORMAT_RGB8,
    ORIGINAL_FORMAT_RGBA8,
    ORIGINAL_FORMAT_RGB32F,
    ORIGINAL_FORMAT_RGBA32F,
    ORIGINAL_FORMAT_NOT_USED,
};

//------------------------------------------------------------------------------
// OriginalImage Field
//------------------------------------------------------------------------------
struct OriginalImageField {
    int index;
    int slice_index;
    std::string face;
    std::string format;
    int width;
    int height;
    int size;
    int stream_idx;
};

//------------------------------------------------------------------------------
// Include proper IDL generated file
//------------------------------------------------------------------------------
#ifdef NW_FOR_CTEX
    #include "ShellExtension_CTEX_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconCTEX
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipCTEX
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewCTEX
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageCTEX
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreCTEX
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderCTEX
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailCTEX

#elif defined NW_FOR_FTX
    #include "ShellExtension_FTX_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconFTX
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipFTX
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewFTX
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageFTX
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreFTX
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderFTX
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailFTX

#elif defined NW_FOR_TGA
    #include "ShellExtension_TGA_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconTGA
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipTGA
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewTGA
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageTGA
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreTGA
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderTGA
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailTGA

#elif defined NW_FOR_PSD
    #include "ShellExtension_PSD_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconPSD
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipPSD
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewPSD
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImagePSD
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStorePSD
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderPSD
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailPSD

#elif defined NW_FOR_AI
    #include "ShellExtension_AI_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconAI
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipAI
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewAI
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageAI
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreAI
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderAI
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailAI

#elif defined NW_FOR_EPS
    #include "ShellExtension_EPS_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconEPS
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipEPS
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewEPS
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageEPS
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreEPS
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderEPS
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailEPS

#elif defined NW_FOR_FXX
    #include "ShellExtension_FXX_h.h"

#elif defined NW_FOR_ESET
    #include "ShellExtension_ESET_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconESET
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipESET
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewESET
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageESET
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreESET
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderESET
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailESET


#elif defined NW_FOR_FLYT
    #include "ShellExtension_FLYT_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconFLYT
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipFLYT
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewFLYT
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageFLYT
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreFLYT
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderFLYT
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailFLYT


#elif defined NW_FOR_THUMBS
    #include "ShellExtension_THUMBS_h.h"

    #define CLSID_ShellExtensionIcon            CLSID_ShellExtensionIconTHUMBS
    #define CLSID_ShellExtensionInfoTip         CLSID_ShellExtensionInfoTipTHUMBS
    #define CLSID_ShellExtensionPreview         CLSID_ShellExtensionPreviewTHUMBS
    #define CLSID_ShellExtensionExtractImage    CLSID_ShellExtensionExtractImageTHUMBS
    #define CLSID_ShellExtensionPropertyStore   CLSID_ShellExtensionPropertyStoreTHUMBS
    #define CLSID_ShellExtensionColumnProvider  CLSID_ShellExtensionColumnProviderTHUMBS
    #define CLSID_ShellExtensionThumbnail       CLSID_ShellExtensionThumbnailTHUMBS

#endif

#endif // End of __ShellExtension_Type_H__

