﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShellExtension_PCH.h"
#include "ShellExtension_SyncObject.h"

//==============================================================================
//
// Implementation of CNWSyncObject
//
//==============================================================================
CNWSyncObject::CNWSyncObject()
{
} // End of Constructor for CNWSyncObject


//------------------------------------------------------------------------------
CNWSyncObject::~CNWSyncObject()
{
} // End of Destructor for CNWSyncObject


//==============================================================================
//
// Implementation of CNWCriticalSection
//
//==============================================================================
CNWCriticalSection::CNWCriticalSection() : CNWSyncObject()
{
    ::InitializeCriticalSection(&m_CS);
} // End of Constructor for CNWCriticalSection


//------------------------------------------------------------------------------
CNWCriticalSection::~CNWCriticalSection()
{
    ::DeleteCriticalSection(&m_CS);
} // End of Destructor for CNWCriticalSection


//------------------------------------------------------------------------------
// Lock
//------------------------------------------------------------------------------
bool CNWCriticalSection::Lock()
{
    ::EnterCriticalSection(&m_CS);
    return true;
} // Ed of Lock for CNWCriticalSection


//------------------------------------------------------------------------------
// Unlock
//------------------------------------------------------------------------------
bool CNWCriticalSection::Unlock()
{
    ::LeaveCriticalSection(&m_CS);
    return true;
} // Ed of Unlock for CNWCriticalSection


//------------------------------------------------------------------------------
// Try to acquire lock without waiting
//------------------------------------------------------------------------------
bool CNWCriticalSection::TryLock()
{
    if (::TryEnterCriticalSection(&m_CS)==false)
        return false;

    return true;
} // End of TryLock for CNWCriticalSection


//==============================================================================
//
// Implementation of CNWSingleLock
//
//==============================================================================
CNWSingleLock::CNWSingleLock( CNWSyncObject *pSyncObject,
                                  bool bInitialLock ) :
    m_pSyncObject(pSyncObject),
    m_bLocked(false)
{
    if (bInitialLock)
        Lock();
} // End of Constructor for CNWSingleLock


//------------------------------------------------------------------------------
CNWSingleLock::~CNWSingleLock()
{
    if (IsLocked())
        Unlock();
} // End of Destructor for CNWSingleLock


//------------------------------------------------------------------------------
bool CNWSingleLock::Lock()
{
    if (m_pSyncObject!=NULL)
    {
        m_pSyncObject->Lock();
        m_bLocked = true;
    } // End if

    return true;
} // End of Lock for CNWSingleLock


//------------------------------------------------------------------------------
bool CNWSingleLock::Unlock()
{
    if (m_pSyncObject!=NULL)
    {
        m_pSyncObject->Unlock();
        m_bLocked = false;
    } // End if

    return true;
} // End of Unlock for CNWSingleLock
