﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_Thumbnail_H__
#define __ShellExtension_Thumbnail_H__

//==============================================================================
//
// Forward declaration
//
//==============================================================================
class CShellExtensionFileData;

//==============================================================================
//
// CShellExtensionThumbnail
//
//==============================================================================
class ATL_NO_VTABLE CShellExtensionThumbnail : public CComObjectRootEx<CComSingleThreadModel>,
                                           public CComCoClass<CShellExtensionThumbnail, &CLSID_ShellExtensionThumbnail>,
                                           public IThumbnailProvider,
                                           public IInitializeWithFile,
                                           public IInitializeWithStream
{
public:
    CShellExtensionThumbnail();
    virtual ~CShellExtensionThumbnail();

    BEGIN_COM_MAP(CShellExtensionThumbnail)
        COM_INTERFACE_ENTRY(IThumbnailProvider)
        COM_INTERFACE_ENTRY(IInitializeWithFile)
        COM_INTERFACE_ENTRY(IInitializeWithStream)
    END_COM_MAP()

    // We do not implement here
    static HRESULT WINAPI UpdateRegistry(BOOL bRegister){ NW_USE_VAR(bRegister); return S_OK; }

public:
    // IThumbnailHandler
    STDMETHODIMP GetThumbnail(UINT cx, HBITMAP *phbmp, WTS_ALPHATYPE *pdwAlpha);

    // IInitializeWithFile
    STDMETHODIMP Initialize( LPCWSTR pszFilePath,
                             DWORD grfMode );

    // IInitializeWithStream
    STDMETHODIMP Initialize(IStream *pstream, DWORD grfMode);

private :
    CShellExtensionFileData *m_pFileData;

public :
    static bool RegisterService( REGISTRATION_PARAM &param );
    static bool UnregisterService( REGISTRATION_PARAM &param );
}; // End of CShellExtensionThumbnail

#endif // End of __ShellExtension_Thumbnail_H__

