﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShellExtension_PCH.h"

#include "ShellExtension_Resource.h"
#include "ShellExtension_Type.h"
#include "ShellExtension_SyncObject.h"
#include "ShellExtension_Texture.h"
#include "ShellExtension_FileData.h"
#include "ShellExtension_Manager.h"
#include "ShellExtension_Utility.h"

#include "Service/Thumbnail/ShellExtension_Thumbnail.h"

//==============================================================================
//
// CShellExtensionThumbnail Implementation
//
//==============================================================================
CShellExtensionThumbnail::CShellExtensionThumbnail() :
    m_pFileData(NULL)
{
    NWShellLockModule();
} // End of Constructor for CShellExtensionThumbnail


//------------------------------------------------------------------------------
CShellExtensionThumbnail::~CShellExtensionThumbnail()
{
    if (m_pFileData!=NULL)
    {
        m_pFileData->Release(L"Thumbnail");
        m_pFileData = NULL;
    } // End if

    NWShellUnlockModule();
} // End of Destructor for CShellExtensionThumbnail


//------------------------------------------------------------------------------
// IThumbnailHandler
//------------------------------------------------------------------------------
STDMETHODIMP CShellExtensionThumbnail::GetThumbnail(UINT cx, HBITMAP *phbmp,
                                                WTS_ALPHATYPE *pdwAlpha)
{
    NW_USE_VAR(cx);
    NW_USE_VAR(phbmp);
    NW_USE_VAR(pdwAlpha);

    NW_LOG(_T("CShellExtensionThumbnail::GetThumbnail"));

    return S_OK;
} // End of GetThumbnail for CShellExtensionThumbnail


//------------------------------------------------------------------------------
// IInitializeWithFile
//------------------------------------------------------------------------------
STDMETHODIMP CShellExtensionThumbnail::Initialize( LPCWSTR pszFilePath,
                                               DWORD grfMode )
{
    NW_USE_VAR(pszFilePath);
    NW_USE_VAR(grfMode);

    return S_OK;
} // End of Initialize for CShellExtensionThumbnail


//------------------------------------------------------------------------------
// IInitializeWithStream
//------------------------------------------------------------------------------
STDMETHODIMP CShellExtensionThumbnail::Initialize(IStream *pstream, DWORD grfMode)
{
    NW_USE_VAR(pstream);
    NW_USE_VAR(grfMode);

    // Not implemented
    return E_NOTIMPL;
} // End of Initialize for CShellExtensionThumbnail


//------------------------------------------------------------------------------
// Register
//------------------------------------------------------------------------------
bool CShellExtensionThumbnail::RegisterService( REGISTRATION_PARAM &param )
{
    WCHAR szGUIDStr[128];
    WCHAR szValStr[128];

    _snwprintf_s(szGUIDStr,127,_TRUNCATE,L"{%s}", NWCreateUUIDString(CLSID_ShellExtensionThumbnail).c_str());

    //--------------------------------------------------------------------------
    // CLSID
    //--------------------------------------------------------------------------
    CRegKey CLSIDKey;
    if (CLSIDKey.Open( HKEY_CLASSES_ROOT,
                       _T("CLSID"),
                       KEY_SET_VALUE )==ERROR_SUCCESS)
    {
        //----------------------------------------------------------------------
        // My Interface ID
        //----------------------------------------------------------------------
        _snwprintf_s(szValStr,127,_TRUNCATE,_T("NintendoWare %s Thumbnail Shell Extension"), param.fileTypeName.c_str() );

        CRegKey GUIDKey;
        if (GUIDKey.Create(CLSIDKey.m_hKey,szGUIDStr)==ERROR_SUCCESS)
        {
            GUIDKey.SetStringValue(NULL,szValStr);

            //------------------------------------------------------------------
            // Inproc server
            //------------------------------------------------------------------
            CRegKey InpProc32Key;
            if (InpProc32Key.Create(GUIDKey.m_hKey,L"InprocServer32")==ERROR_SUCCESS)
            {
                InpProc32Key.SetStringValue(NULL,param.moduleName.c_str());
                InpProc32Key.SetStringValue(L"ThreadingModel", L"Apartment");
                InpProc32Key.Close();
            } // End if

            GUIDKey.Close();
        } // End if

        CLSIDKey.Close();
    } // End if

    //--------------------------------------------------------------------------
    // ProgID
    //--------------------------------------------------------------------------
    int i;
    for (i=0;i<(int)param.supportedExtensions.size();i++)
    {
        CRegKey progIDKey;
        if (progIDKey.Open( HKEY_CLASSES_ROOT,
                            param.progIDNames[i].c_str(),
                            KEY_SET_VALUE )==ERROR_SUCCESS)
        {
            //------------------------------------------------------------------
            // ShellEx Icon
            //------------------------------------------------------------------
            CRegKey shellExKey;
            if (shellExKey.Open(progIDKey.m_hKey,
                                L"ShellEx",
                                KEY_SET_VALUE)==ERROR_SUCCESS)
            {
                //--------------------------------------------------------------
                // ShellEx Icon
                //--------------------------------------------------------------
                CRegKey handlerKey;
                if (handlerKey.Create(shellExKey.m_hKey,L"{E357FCCD-A995-4576-B01F-234630154E96}")==ERROR_SUCCESS)
                {
                    handlerKey.SetStringValue(NULL,szGUIDStr);
                    handlerKey.Close();
                } // End if

                shellExKey.Close();
            } // End if

            progIDKey.Close();
        } // End if
    } // End for

    return true;
} // End of RegisterService for CShellExtensionThumbnail


//------------------------------------------------------------------------------
// Unregister
//------------------------------------------------------------------------------
bool CShellExtensionThumbnail::UnregisterService( REGISTRATION_PARAM &param )
{
    NW_USE_VAR(param.supportedExtensions.size());

    WCHAR szGUIDStr[128];
    _snwprintf_s(szGUIDStr,127,_TRUNCATE,L"{%s}", NWCreateUUIDString(CLSID_ShellExtensionThumbnail).c_str());

    //--------------------------------------------------------------------------
    // CLSID
    //--------------------------------------------------------------------------
    CRegKey CLSIDKey;
    if (CLSIDKey.Open ( HKEY_CLASSES_ROOT,
                        _T("CLSID"),
                        KEY_SET_VALUE )==ERROR_SUCCESS)
    {
        //----------------------------------------------------------------------
        // My Interface ID
        //----------------------------------------------------------------------
        CLSIDKey.RecurseDeleteKey(szGUIDStr);

        CLSIDKey.Close();
    } // End if

    return true;
} // End of UnregisterService for CShellExtensionThumbnail
