﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShellExtension_FTXLoader_H__
#define __ShellExtension_FTXLoader_H__

#ifdef NW_FOR_FTX
#include<memory>
//==============================================================================
//
// Forward declaration
//
//==============================================================================
struct _GX2Surface;

//==============================================================================
//
// NW FTXLoader
//
// - Derived from ImageLoader to load .ftxa or .ftxb files
//
//==============================================================================
class CNWFTXLoader : public CNWImageLoader
{
public :
    CNWFTXLoader();
    virtual ~CNWFTXLoader();

    //--------------------------------------------------------------------------
    // Load from image file onto pTexture
    //
    // - If bLoadPreview is true, create preview image for icon
    //   If bLoadPreview is false, just load information ( format, size etc )
    //--------------------------------------------------------------------------
    virtual bool Load( CNWTexture *pTexture,
                       const WCHAR *szFilePath,
                       bool bLoadPreview );

private :
    //--------------------------------------------------------------------------
    //  Load Binary Image Stream
    //--------------------------------------------------------------------------
    const unsigned char *LoadBinaryImageStream( const unsigned char *pBinarySection,
                                                 int iStreamIndex,
                                                 int &iDataSize);


    //--------------------------------------------------------------------------
    // Load ASCII Image Stream
    //--------------------------------------------------------------------------
    std::unique_ptr<const unsigned char[]> LoadASCIIImageStream( int iStreamIndex,
                                                MSXML2::IXMLDOMNodePtr textureNode,
                                                int &iDataSize );

    //------------------------------------------------------------------------------
    // Load Binary Original Streams
    //------------------------------------------------------------------------------
    std::vector<const unsigned char*> LoadBinaryOriginalStream( CNWTexture *pTexture,
                                                    const unsigned char *pBinarySection,
                                                    MSXML2::IXMLDOMNodePtr textureNode,
                                                    int &iStreamNum);

    //------------------------------------------------------------------------------
    // Load ASCII Original Streams
    //------------------------------------------------------------------------------
    std::unique_ptr<std::unique_ptr<const unsigned char[]>[]> LoadASCIIOriginalStream( CNWTexture *pTexture,
                                                   MSXML2::IXMLDOMNodePtr textureNode,
                                                   int &iStreamNum );

    //--------------------------------------------------------------------------
    // Get stream XML node with given index
    //--------------------------------------------------------------------------
    MSXML2::IXMLDOMNodePtr GetStreamByIndex( MSXML2::IXMLDOMNodePtr streamArrayNode,
                                             int index );

    //--------------------------------------------------------------------------
    // Read XML section to buffer for parsing
    //--------------------------------------------------------------------------
    bool ReadXMLSectionToBuffer( const unsigned char *pRawBuffer,
                                 int iBufferSize,
                                 VARIANT *pXMLBuffer );

    //--------------------------------------------------------------------------
    // Decode text into images
    //--------------------------------------------------------------------------
    std::unique_ptr<unsigned char[]> DecodeStreamTextToBuffer( const unsigned char* srcBuf, int srcSize,
                                             int& dstSize);

    std::unique_ptr<unsigned char[]> DecodeStreamTextToFloatBuffer( const unsigned char* srcBuf,
                                                  int srcSize,
                                                  int format,
                                                  int& dstSize);

    //--------------------------------------------------------------------------
    // Read binary chunk header
    //--------------------------------------------------------------------------
    const unsigned char *ReadBinaryChunkHeader( const unsigned char *pByte,
                                                std::unique_ptr<int[]>* streamOffsets,
                                                std::unique_ptr<int[]>* streamSizes);

    const unsigned char *SkipToStreamHead( const unsigned char *pBinaryChunk,
                                           int *streamOffsets,
                                           int stream_idx,
                                           int &iDataSize);

    //------------------------------------------------------------------------------
    // Original image to preview image
    //------------------------------------------------------------------------------
    bool CNWFTXLoader::ConvertStreamToSurface( CNWTexture *pTexture,
                                               const unsigned char* srcBuf,
                                               int srcBufSize,
                                               MSXML2::IXMLDOMNodePtr textureNode );

    bool ConvertOriginalStreamToPreviewImage( CNWTexture *pTexture,
                                              const unsigned char** srcBuf,
                                              int iStreamNum );

    //------------------------------------------------------------------------------
    // image stream to preview image
    //------------------------------------------------------------------------------
    bool ConvertImageStreamToPreviewImage(CNWTexture *pTexture,
        const unsigned char* srcBuf,
        const std::string& format);
}; // End of CNWFTXLoader

#endif // End of NW_FOR_FTX

#endif // End of __ShellExtension_FTXLoader_H__

