﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShellExtension_PCH.h"
#include "ShellExtension_Utility.h"
#include "ShellExtension_Type.h"
#include "ShellExtension_Texture.h"
#include "ImageLoader/ShellExtension_ImageLoader.h"
#include "ImageLoader/ShellExtension_AILoader.h"
//#include "ImageLoader/ShellExtension_CTexLoader.h"
#include <algorithm>
#include <vector>

//==============================================================================
//
// Utility functions
//
//==============================================================================
namespace
{

} // End namespace


//==============================================================================
//
// Implementation of CNWAILoader
//
//==============================================================================
CNWAILoader::CNWAILoader() :
    CNWImageLoader()
{
} // End of Constructor for CNWPSDLoader


//------------------------------------------------------------------------------
CNWAILoader::~CNWAILoader()
{
} // End of Destructor for CNWPSDLoader

namespace
{
    void ContentRange(char* begin, char* end, const char* startTag, const char* endTag, char*& rangeBegin, char*& rangeEnd)
    {
        auto startLength = strlen(startTag);
        rangeBegin = std::search(begin, end, startTag, startTag + startLength);
        if (rangeBegin == end)
        {
            rangeEnd = end;
            return;
        }

        rangeBegin += startLength;
        rangeEnd = std::search(rangeBegin, end, endTag, endTag + strlen(endTag));
    }
}

//------------------------------------------------------------------------------
// Load from image file onto pTexture
//
// - If bLoadPreview is true, create preview image for icon
//   If bLoadPreview is false
//------------------------------------------------------------------------------
#pragma warning (push)
#pragma warning (disable : 4100) // bLoadPreview の未使用の警告抑制
bool CNWAILoader::Load(CNWTexture *pTexture,
    const WCHAR *szFilePath,
    bool bLoadPreview)
{
    pTexture->Destroy();

    FILE* file = NULL;
    _wfopen_s(&file, szFilePath, L"rb");
    if (file == NULL)
        return false;

    std::unique_ptr<std::FILE, decltype(&std::fclose)> fp(file, &std::fclose);

    fseek(file, 0, SEEK_END);
    int fileSize = ftell(file);
    fseek(file, 0, SEEK_SET);

    std::unique_ptr<char[]> pBuffer(new char[fileSize]);
    if (pBuffer == nullptr)
    {
        return false;
    }

    if (fread(pBuffer.get(), fileSize, 1, file) != 1)
    {
        return false;
    }

    // ファイルを閉じる
    fp.reset();

    // サムネイルの範囲の取得
    // xml としてきちんと処理していないので、厳密には正しくない
    char* pThumbnailsBegin;
    char* pThumbnailsEnd;
    ContentRange(pBuffer.get(), pBuffer.get() + fileSize, "<xmp:Thumbnails>", "</xmp:Thumbnails>", pThumbnailsBegin, pThumbnailsEnd);

    if (pThumbnailsBegin != pThumbnailsEnd)
    {
        char* pImageBegin;
        char* pImageEnd;
        // 画像の範囲の取得
        // xml としてきちんと処理していないので、厳密には正しくない
        ContentRange(pThumbnailsBegin, pThumbnailsEnd, "<xmpGImg:image>", "</xmpGImg:image>", pImageBegin, pImageEnd);
        if (pImageBegin != pImageEnd)
        {
            auto pTarget = pImageBegin;
            auto pSource = pImageBegin;
            auto LF = "&#xA;";
            auto LFLength = strlen(LF);

            // 改行文字を取り除く
            while (true)
            {
                auto pSourceEnd = std::search(pSource, pImageEnd, LF, LF + LFLength);
                auto length = pSourceEnd - pSource;
                memmove(pTarget, pSource, length);
                pTarget += length;
                if (pSourceEnd == pImageEnd)
                {
                    break;
                }
                else
                {
                    pSource = pSourceEnd + LFLength;
                }
            }

            int dataSize;

            // Base64 をデコード
            std::unique_ptr<unsigned char[]> data = NWDecodeBase64(reinterpret_cast<const unsigned char*>(pImageBegin), static_cast<int>(pTarget - pImageBegin), dataSize);
            if (data)
            {
                std::unique_ptr<void, decltype(&::GlobalFree)> p(::GlobalAlloc(GMEM_FIXED, dataSize), &::GlobalFree);
                if (p != nullptr)
                {
                    memcpy(p.get(), data.get(), dataSize);
                    IStream* pStream = nullptr;
                    if (::CreateStreamOnHGlobal(p.get(), TRUE, &pStream) == S_OK)
                    {
                        // 所有権を開放する
                        p.release();

                        auto deleter = [](IStream* x) { x->Release(); };
                        std::unique_ptr<IStream, decltype(deleter)> pS(pStream, deleter);
                        std::unique_ptr<Gdiplus::Bitmap> pBitmap(Gdiplus::Bitmap::FromStream(pStream));
                        if (pBitmap != nullptr)
                        {
                            if (pBitmap->GetLastStatus() == Gdiplus::Status::Ok)
                            {
                                // Stream を開放したいので、DrawImage を使ってコピー
                                std::unique_ptr<Gdiplus::Bitmap> pBitmap2(new Gdiplus::Bitmap(pBitmap->GetWidth(), pBitmap->GetHeight(), PixelFormat32bppARGB));
                                if (pBitmap2 && pBitmap2->GetLastStatus() == Gdiplus::Status::Ok)
                                {
                                    Gdiplus::Graphics g(pBitmap2.get());
                                    g.DrawImage(pBitmap.get(), 0, 0, pBitmap2->GetWidth(), pBitmap2->GetHeight());
                                    pTexture->SetPreviewBitmap(pBitmap2.release());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    return pTexture->GetPreviewBitmap() != nullptr;
}
#pragma warning (pop)



