﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NintendoWare.ExtensionManager
{
    public partial class NoticeShutdownDialog : Form
    {
        protected int proSec;
        public NoticeShutdownDialog()
        {
            InitializeComponent();

            proSec = 5;
            this.m_srcText = this.m_labelNotice2.Text;
            this.m_labelNotice2.Text = String.Format(this.m_srcText, proSec);

            Timer timer = new Timer();
            timer.Tick += new EventHandler(MyTimer);
            timer.Interval = 1000;      //1秒毎に呼び出し
            timer.Enabled = true;

        }

        public void MyTimer(object sender, EventArgs e)
        {
            proSec--;

            if (proSec<=0)
            {
                // 5秒経過
                this.Close();
            }
            else
            {
                // 5秒以内は表示を更新
                this.m_labelNotice2.Text = String.Format(this.m_srcText, proSec);
            }
        }
    }
}
