﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// Shell DLL
    /// </summary>
    //==========================================================================
    public class ShellPlugin
    {
        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public ShellPlugin()
        {
        }

        #region Name
        //----------------------------------------------------------------------
        /// <summary>
        /// Plugin Name
        /// </summary>
        //----------------------------------------------------------------------
        public String PluginName
        {
            set;
            get;
        }
        #endregion

        #region Path to module
        //----------------------------------------------------------------------
        /// <summary>
        /// Path to module ( 64 bit )
        /// </summary>
        //----------------------------------------------------------------------
        public String ModulePath64Bit
        {
            set;
            get;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Path to module ( 32 bit )
        /// </summary>
        //----------------------------------------------------------------------
        public String ModulePath32Bit
        {
            set;
            get;
        }
        #endregion

        public IEnumerable<string> SupportedExtensions
        {
            get;
            set;
        }

    }
}
