﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace nw.g3d.bifedit
{
    public class CustomMessageBox
    {
        public static DialogResult Show(string text, string caption, MessageBoxButtons buttons, MessageBoxIcon icon)
        {
            using (var mcd = new MethodCallDump("CustomMessageBox.Show", "text: '{0}', caption: '{1}'", text, caption))
            {
                if (string.IsNullOrWhiteSpace(text))
                    throw new ArgumentException("'text' argument must be set to a valid non-empty string value.");

                mcd.Log("'text' argument OK");

                if (string.IsNullOrWhiteSpace(caption))
                    throw new ArgumentException("'caption' argument must be set to a valid non-empty string value.");

                mcd.Log("'caption' argument OK");

                if (buttons != MessageBoxButtons.OK)
                    throw new NotSupportedException("Values of 'buttons' argument different than 'OK' are not supported.");

                if (icon != MessageBoxIcon.Error)
                    throw new NotSupportedException("Values of 'icon' argument different than 'Error' are not supported.");

                var ready = new ManualResetEvent(false);
                CustomMessageBoxForm form = null;

                mcd.Log("Primary UI Thread> Run Secondary UI Thread for custom message dialog");

                new Thread(_ =>
                {
                    form = new CustomMessageBoxForm
                    {
                        Text = caption,
                        Message = text,
                    };

                    form.Show(null);
                    mcd.Log("Secondary UI Thread> Call form.Show(null)");
                    form.Activate();
                    mcd.Log("Secondary UI Thread> Call form.Activate()");

                    form.TopMost = false;
                    form.TopMost = true;

                    ready.Set();
                    mcd.Log("Secondary UI Thread> Custom message dialog ready");

                    Application.Run(form);
                    mcd.Log("Secondary UI Thread> Done");
                })
                {
                    IsBackground = true,
                    Name = "CustomMessageBox UI Thread",
                }.Start();

                mcd.Log("Primary UI Thread> Wait for Secondary UI Thread to be ready");
                ready.WaitOne();
                mcd.Log("Primary UI Thread> Custom message dialog ready");
                form.WaitHandle.WaitOne();
                mcd.Log("Primary UI Thread> Custom message dialog on Secondary UI Thread has been closed");

                return mcd.LogReturnValue(DialogResult.OK);
            }
        }
    }
}
