﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace NW4F.LayoutBinaryConverter.TexConv
{
    public class SrcImage
    {
        /// <summary>
        /// 画像のなまえ
        /// </summary>
        public string name;

        /// <summary>
        /// 出力フォーマット
        /// </summary>
        public TexelFormat dstFormat;

        /// <summary>
        /// インダイレクトテクスチャ用途かどうか（カラーコンポーネント選択に影響します）
        /// </summary>
        public bool isIndirectTexture;

        /// <summary>
        /// ガンマ補正を行う必要があるかどうか？（isSrgbFormat を利用する場合 false になるはず）
        /// </summary>
        public bool isDegamma;

        /// <summary>
        /// SRGB フォーマットを利用するかどうか（SRGB フォーマットはシェーダーでフェッチする際にガンマ補正を行う）
        /// </summary>
        public bool isSrgbFormat;

        /// <summary>
        /// スイズルに設定する値
        /// </summary>
        public int swizzlePattern;

        /// <summary>
        /// カラー画像
        /// </summary>
        public Layer lyColor;

        /// <summary>
        /// アルファ画像
        /// </summary>
        public Layer lyAlpha;

        /// <summary>
        /// パレットテーブル（利用されていません）
        /// </summary>
        public PaletteTable palPtr;

        public void AddCacheKey(CacheKeyGenerator gen)
        {
            gen.AddCacheKey(name);
            gen.AddCacheKey((int)dstFormat);
            gen.AddCacheKey(isIndirectTexture);
            gen.AddCacheKey(isDegamma);
            gen.AddCacheKey(isSrgbFormat);
            gen.AddCacheKey(swizzlePattern);

            if (lyColor != null)
            {
                gen.AddCacheKey(true);
                lyColor.AddCacheKey(gen);
            }
            else
            {
                gen.AddCacheKey(false);
            }

            if (lyAlpha != null)
            {
                gen.AddCacheKey(true);
                lyAlpha.AddCacheKey(gen);
            }
            else
            {
                gen.AddCacheKey(false);
            }

            // palPtr は無視
        }
    }
}
