﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#pragma warning(push)

// 外部参照ヘッダとの文字コード不一致による警告を抑止
#pragma warning(disable:4819)

//#include <nn/types.h>

#pragma warning(pop)

#include <string>
#include <windows.h>

#include <Encoder/Encoder.h>
#include <Sources/3dTextureConverter.h>
#include <cstdint>
#include <Sources/NxTypes.h>

namespace NW4F
{
    namespace LayoutBinaryConverter
    {
        //=============================================================================
        //! @brief エンコーダのクラスです。
        //=============================================================================
        class REncoder
        {
        protected:
            HMODULE m_hDll;        //!< コンバーターの DLL のインスタンスハンドルです。
            HMODULE m_hDllEncoder; //!< エンコーダの DLL のインスタンスハンドルです。
            HMODULE m_hDllNX;      //!< NX用コンバータの DLL のインスタンスハンドルです。
            std::wstring m_TextureConverterExePath;
            std::wstring m_TextureConverterNXPath;

        public:
            nn::gfx::tool::texcvtr::SetOptionsFunc SetOptions; //!< エンコード後のデータサイズ（バイト数）を取得する関数です。
            nn::gfx::tool::texcvtr::ClearFunc Clear; //!< 画像のフォーマットを変換する関数です。
            nn::gfx::tool::texcvtr::ReadBitmapDataFunc ReadBitmapData; //!< エンコード後のデータサイズ（バイト数）を取得する関数です。
            nn::gfx::tool::texcvtr::ConvertToDataFunc ConvertToData; //!< 画像のフォーマットを変換する関数です。
            nn::gfx::tool::texcvtr::GetErrorStringFunc GetErrorString; //!< エンコード後のデータサイズ（バイト数）を取得する関数です。

            nn::gfx::tool::texenc::GetDataSizeFunction GetDataSize; //!< エンコード後のデータサイズ（バイト数）を取得する関数です。
            nn::gfx::tool::texenc::ConvertFormatFunction ConvertFormat; //!< 画像のフォーマットを変換する関数です。
            nn::gfx::tool::texenc::IsGpuEncodingAvailableFunction IsGpuEncodingAvailable; // 現在の環境で GPU によるエンコーディングが可能なら true を返します。

            nn::gfx::tool::texcvtr::ConvertTilingFunction ConvertTilingNX; // NX用
            nn::gfx::tool::texcvtr::ReleaseTextureFunction ReleaseTextureNX; // NX用
            nn::gfx::tool::texcvtr::GetDataSizeNXFunction GetDataSizeNX; // NX用

        public:
            //! @biref コンストラクタです。
            REncoder() :
                m_hDll(NULL),
                m_hDllEncoder(NULL),
                m_hDllNX(NULL),
                SetOptions(NULL),
                Clear(NULL),
                ReadBitmapData(NULL),
                ConvertToData(NULL),
                GetErrorString(NULL),
                GetDataSize(NULL),
                GetDataSizeNX(NULL),
                ConvertFormat(NULL),
                ConvertTilingNX(NULL),
                ReleaseTextureNX(NULL)
            {
            }

            //! @biref デストラクタです。
            ~REncoder()
            {
                Finalize();
            }

            //! @biref 初期化します。
            //!
            //! @param[in] dllPath エンコーダの DLL ファイルのパスです。
            //!                    NULL なら SetDllPath で設定したパスを使用します。
            //!
            //! @return 処理結果を返します。
            //!
            int Initialize(const wchar_t* dllPath);

            //! @biref NX用タイリング API を初期化します。
            //!
            //! @return 処理結果を返します。
            //!
            int InitializeNXTilingApi();

            //! @biref 終了します。
            void Finalize(void);

            //! @biref 初期化済みなら true を返します。
            bool IsInitialized(void) const { return (m_hDll != NULL); }
            bool IsNXInitialized(void) const { return IsInitialized() && (m_hDllNX != NULL); }
            const std::wstring& GetTextureConverterExePath(){ return m_TextureConverterExePath; }
        };

        //=============================================================================
        // テクスチャ生成クラスです。
        public ref class GenericTextureWriter : public TexConv::ITexttureWriter
        {
        public:
            GenericTextureWriter()
                : m_pEncoder(NULL)
                , m_isLogSilent(false)
                , m_isGpuEncodigEnabled("true")
            {
            }

            bool InitializeEncoder(System::String^ encoderPath);
            void FinalizeEncoder();

            virtual TexConv::ConvertedImage^ ConvertSrcImageToNative2DArrayFormat(array<TexConv::SrcImage^>^ texImage, System::String^ tileMode, bool useBntx);
            virtual bool ExportSrcImageToFtxbFile(TexConv::SrcImage^ texImage, System::String^ apiTypeName, System::String^ outputDir, System::String^ cacheDir);

            virtual void SetLogSilent(bool isLogSilent)
            {
                m_isLogSilent = isLogSilent;
            }

            virtual void SetGpuEncodingEnabled(System::String^ isGpuEncodigEnabled)
            {
                m_isGpuEncodigEnabled = isGpuEncodigEnabled;
            }

            System::IntPtr ConvertTiling( bool isTiling, System::IntPtr pSrcData, System::UInt64 srcDataSize, System::String^ dimension, System::String^ format, int imageW, int imageH, int imageD, int arrayLength, int mipCount, System::String^ tileMode, System::UInt64% dstDataSize, System::IntPtr pTextureLayout, bool isSparseTiled);
            int GetNativeDataSize(TexConv::TexelFormat format, int imageW, int imageH);
            int GetNativeDataSizeNX(TexConv::TexelFormat format, int imageW, int imageH, uint32_t tilingFlags, int sizeThreshold);
            bool InitializeNXApi();

            bool IsGpuEncodingAvailable();

        private:
            REncoder* m_pEncoder;
            bool m_isLogSilent;
            System::String^ m_isGpuEncodigEnabled;
        };

    }   // namespace LayoutBinaryConverter
}   // namespace NW4F
