﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NW4F.LayoutBinaryConverter
{
    public enum Endian
    {
        Little,
        Big,
    }

    public class EndianEnvironment
    {
        public static Endian ResouceEndian = Endian.Little;
    }

    /// <summary>
    /// エンディアンを明示できるBinaryWriterです。
    /// </summary>
    public class EndianAwareBinaryWriter : BinaryWriter
    {
        /// <summary>
        /// エンディアンを指定してバイナリライターを生成します。
        /// </summary>
        /// <param name="endian">エンディアンです。</param>
        /// <param name="stream">ストリームです。</param>
        /// <returns>endianの指定に応じたBinaryWriterクラスのオブジェクトを返します。</returns>
        public static BinaryWriter CreateBinaryWriter(Endian endian, Stream stream)
        {
            switch (endian)
            {
                case Endian.Little:
                    return new BinaryWriter(stream);
                case Endian.Big:
                    return new NetOrderBinaryWriter(stream);
                default:
                    throw new LayoutConverterException("unexpected endian.");
            }
        }

        /// <summary>
        /// リソースのエンディアンに応じたバイナリライターを生成します。
        /// Cafe向けでは、リソースのエンディアンはビックエンディアンとなります。
        /// </summary>
        /// <param name="stream">ストリームです。</param>
        /// <returns>リソースのエンディアンに応じたBinaryWriterクラスのオブジェクトを返します。</returns>
        public static BinaryWriter CreateResouceEndianBinaryWriter(Stream stream)
        {
            if (EndianEnvironment.ResouceEndian == Endian.Little)
            {
                return new BinaryWriter(stream);
            } else {
                return new NetOrderBinaryWriter(stream);
            }
        }
    }
}
