﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NW4F.LayoutBinaryConverter
{
    using Lyt = Schema.Flyt;
    using Lan = Schema.Flan;

    /// <summary>
    /// 読み込み済みのFlyt, Flanを管理します。
    /// 現状ではRlyt1つをキャッシュします。
    /// </summary>
    class DocumentManager
    {
        Tuple<LytInfo> _lytTuple = new Tuple<LytInfo>();
        Tuple<LanInfo> _lanTuple = new Tuple<LanInfo>();
        readonly LayoutFileLoader _fileLoader;

        struct Tuple<T>
        {
            public T data;
            public string fullPath;
        }

        public DocumentManager(LayoutFileLoader rlytLoader)
        {
            _fileLoader = rlytLoader;
        }

        public LytInfo GetRlyt(string fullPath)
        {
            if (_lytTuple.fullPath == fullPath)
            {
                return _lytTuple.data;
            }

            _lytTuple.data = _fileLoader.LoadLYT(fullPath);
            _lytTuple.fullPath = fullPath;

            return _lytTuple.data;
        }

        public LanInfo GetRlan(string fullPath)
        {
            if (_lanTuple.fullPath == fullPath)
            {
                return _lanTuple.data;
            }

            _lanTuple.data = _fileLoader.LoadLAN(fullPath, GetRlyt(FileUtil.GetLayoutFileName(fullPath)));
            _lanTuple.fullPath = fullPath;

            // フォーマットを変換する
            AnimConverter animConverter = new AnimConverter(_lanTuple.data);
            animConverter.ConvertMultiToSingle();

            return _lanTuple.data;
        }
    }
}
