﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "StdAfx.h"
#include "WriteCommon.h"

using namespace System;
using namespace System::IO;

namespace NW4F
{
namespace LayoutBinaryConverter
{

/*
    名前文字列のコピー
*/
void
CopyNameStr(char dst[], String^ src, int size)
{
    array<Byte>^ byteArray = System::Text::Encoding::ASCII->GetBytes(src);

    if (byteArray->Length > size)
    {
        throw gcnew ArgumentOutOfRangeException("size");
    }

    int i = 0;
    for (; i < byteArray->Length; ++i)
    {
        dst[i] = byteArray[i];
    }
    for (; i < size; ++i)
    {
        dst[i] = 0;
    }
}

/*
    名前文字列のコピー
        終端に'\0'があるバージョン
*/
void
CopyNameStrToCStr(char dst[], String^ src, int size)
{
    CopyNameStr(dst, src, size - 1);
    dst[size - 1] = 0;
}

float
HostToTarget(float val)
{
#ifdef NW
    return val;
#else
    uint32_t wkVal = *reinterpret_cast<uint32_t*>(&val);
    wkVal =    (wkVal << 24)
            | ((wkVal <<  8) & 0x00FF0000)
            | ((wkVal >>  8) & 0x0000FF00)
            |  (wkVal >> 24);
    return *reinterpret_cast<float*>(&wkVal);
#endif
}

uint16_t
HostToTarget(uint16_t val)
{
#ifdef NW
    return val;
#else
    return    (val <<  8)
            | (val >>  8);
#endif
}

int16_t
HostToTarget(int16_t val)
{
#ifdef NW
    return val;
#else
    return int16_t(HostToTarget(uint16_t(val)));
#endif
}

uint32_t
HostToTarget(uint32_t val)
{
#ifdef NW
    return val;
#else
    return     (val << 24)
            | ((val <<  8) & 0x00FF0000)
            | ((val >>  8) & 0x0000FF00)
            |  (val >> 24);
#endif
}

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
