﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

#define SHARC_ARCHIVE_VERSION       0x0100      ///< このコンバータ＆ランタイムのバージョン.
#define SHARC_MAX_TOTAL_DATA_SIZE   0xffffffff  ///< データブロックに格納できる最大長さ.
#define SHARC_FNT_ALIGN             4           ///< FileNameTableのアライメント.

namespace sharc {
//------------------------------------------------------------------------------

const uint32_t cDefaultHashKey = 101;
const int cMaxPathNum = 0x3fff;         ///< アーカイブできる最大ファイル数

/// ArchiveBlockHeaderのoptionのビットごとの意味
enum ArchiveOption{
    cArchiveOption_Unsafe = 0x0001      ///< FNT(File Name Table)に全てのパスを書き込むか
};

struct ArchiveBlockHeader
{
    char    signature[ 4 ];     ///< "CRAS".
    uint16_t     header_size;        ///< このブロックヘッダの大きさ.
    uint16_t     byte_order;         ///< バイトオーダーマーク(0xfeff).
    uint32_t     file_size;          ///< このファイル全体の大きさ(HeaderBlockを含む).
    uint32_t     data_block_offset;  ///< ファイル先頭からデータブロックまでのオフセット.
    uint16_t     version;            ///< 上位8ビットと下位8ビットに分けてバージョンを保存.
    uint16_t     reserved;               ///< オプション.
};

struct FATBlockHeader
{
    char    signature[ 4 ]; ///< "TAFS".
    uint16_t     header_size;    ///< このブロックヘッダの大きさ.
    uint16_t     file_num;       ///< ファイル数.
    uint32_t     hash_key;       ///< ハッシュのキー.
};

struct FATEntry
{
    uint32_t hash;               ///< ハッシュ.
    uint32_t name_offset;        ///< 上位8bitに同じハッシュ内のID(1から開始)、残りの24bitに名前の位置÷SHARC_FNT_ALIGN.
    uint32_t data_start_offset;  ///< データ開始位置.
    uint32_t data_end_offset;    ///< データ終了位置.
};

struct FNTBlockHeader
{
    char    signature[ 4 ]; ///< "TNFS".
    uint16_t     header_size;    ///< このブロックヘッダの大きさ.
    uint16_t     reserved;       ///< パディング.
};

//------------------------------------------------------------------------------

} // namespace sherbet
