﻿#include "FontInfoGetter.h"

namespace NintendoWare { namespace FontInfoGetter {

template <typename ValueT>
inline ValueT
    RoundUp(ValueT x, uint32_t base)
{
    uint32_t mask = base - 1;
    return static_cast<ValueT>(x + mask) & ~mask;
}

uint32_t BSwap(uint32_t val)
{
    const uint32_t MASK = 0xFF00FF00;
    val = ((val & MASK) >> 8) | ((val << 8) & MASK);
    return (val >> 16) | (val << 16);
}

void* DecodeBfttf::Decode(void* pData, uint32_t dataSize)
{
    if (dataSize < 8)
    {
        // データサイズが8より小さい場合は不正
        return NULL;
    }
    static const uint32_t SCRAMBLE_SIGNETURE = 0x7f9a0218;
    uint32_t* data = static_cast<uint32_t*>(pData);
    if (BSwap(data[0]) == SCRAMBLE_SIGNETURE)
    {
        // デコード済み、何もせずに返す
        return reinterpret_cast<void*>(&data[2]);
    }
    else
    {
        // デコードしていない
        uint32_t scrambleKey = BSwap(data[0]) ^ SCRAMBLE_SIGNETURE;
        {
            // 正しいbffntのデータ
            // ttfのサイズを取得
            uint32_t ttfSize = BSwap(data[1]) ^ scrambleKey;
            if (dataSize < ttfSize)
            {
                // ttfのサイズがデータサイズより大きい場合は不正
                return NULL;
            }
            // スクランブル解除
            data[0] = BSwap(SCRAMBLE_SIGNETURE);
            uint32_t loopEnd = RoundUp(ttfSize, 4) / 4 + 2;
            for (uint32_t i = 2; i < loopEnd; i++)
            {
                data[i] = BSwap(BSwap(data[i]) ^ scrambleKey);
            }
            return reinterpret_cast<void*>(&data[2]);
        }
    }
}

} } // namespace NintendoWare::FontInfoGetter
