﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Panel.Property
{
    using FcpxMaker.DataModel;
    using Node;
    using static Type;

    public partial class ScalableFontPropertyPanel : PropertyPanelBase
        , IEventListener
    {
        /// <summary>
        /// 操作対象のデータモデルです。
        /// </summary>
        private ScalableFontDataModel TargetDataModel
        {
            get
            {
                return Target as ScalableFontDataModel;
            }
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        override public void UpdateProperty()
        {
            if (TargetDataModel != null)
            {
                _nudFontSize.Value = new decimal(TargetDataModel.FontSize);
                _tbxAlternateChar.Text = Convert.ToChar(TargetDataModel.AlternateChar).ToString();
                _nudLineFeedOffset.Value = TargetDataModel.LineFeedOffset;
            }
        }

        /// <summary>
        ///コンストラクタです。
        /// </summary>
        public ScalableFontPropertyPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// イベントを通知します。
        /// </summary>
        public void dispatch(object sender, EventArgs arg)
        {
            EventParam param = arg as EventParam;

            switch (param.Type)
            {
                case EventType.PasteParams:
                    {
                        UpdateProperty();
                    }
                    break;
            }
        }

        /// <summary>
        /// フォントサイズが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_FontSizeValueChanged(object sender, EventArgs e)
        {
            TargetDataModel.FontSize = (float)_nudFontSize.Value;

            // データの変更を通知します
            NotifyDataModified();
        }

        /// <summary>
        /// 代替文字が変更された時のイベントハンドラです。
        /// </summary>
        private void Event_AlternateCharTextChanged(object sender, EventArgs e)
        {
            TargetDataModel.AlternateChar = _tbxAlternateChar.Text.FirstOrDefault();

            // ツリービューの更新要求を通知します
            NotifyUpdateTreeView();

            // データの変更を通知します
            NotifyDataModified();
        }

        /// <summary>
        /// 行間オフセットが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_LineFeedOffsetValueChanged(object sender, EventArgs e)
        {
            TargetDataModel.LineFeedOffset = Decimal.ToInt32(_nudLineFeedOffset.Value);

            // データの変更を通知します
            NotifyDataModified();
        }
    }
}
