﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker
{
    using DataModel;
    using Node;
    using Panel.Property;
    using static Type;

    public partial class BitmapFontPropertyPanel : PropertyPanelBase
        , IEventListener
    {
        /// <summary>
        /// 操作対象のデータモデルです。
        /// </summary>
        private BitmapFontDataModel TargetDataModel
        {
            get
            {
                return Target as BitmapFontDataModel;
            }
        }

        /// <summary>
        /// データモデルを関連付けます。
        /// </summary>
        override public void BindTarget(DataModelBase target)
        {
            this.Target = target;
            _pnlFontRangePropertyPanel.BindTarget(TargetDataModel.CharCodeRangeDataModel);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BitmapFontPropertyPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// イベントを通知します。
        /// </summary>
        public void dispatch(object sender, EventArgs arg)
        {
            EventParam param = arg as EventParam;

            switch (param.Type)
            {
                case EventType.PasteParams:
                    {
                        UpdateProperty();
                    }
                    break;
            }
        }
    }
}
