﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Node
{
    using DataModel;
    using static FcpxMaker.Type;

    /// <summary>
    /// データを扱うノードです。
    /// </summary>
    public class DataNode : TreeNode
    {
        private DataType _dataType = DataType.None;

        /// <summary>
        /// データの種類です。
        /// </summary>
        public DataType DataType
        {
            get { return _dataType; }
            set
            {
                _dataType = value;
                Text = _dataType.ToString();
            }
        }

        /// <summary>
        /// データモデルです。
        /// </summary>
        public DataModelBase DataModel { get; set; }

        /// <summary>
        /// ノードを複製します。
        /// </summary>
        public override object Clone()
        {
            DataNode newNode = base.Clone() as DataNode;
            newNode.DataType = this.DataType;
            newNode.DataModel = this.DataModel?.Clone();

            return newNode;
        }
    }
}
