﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FcpxMaker.DataModel
{
    using static FcpxMaker.Type;

    /// <summary>
    /// データモデルの基底クラスです。
    /// </summary>
    [Serializable]
    public class DataModelBase
    {
        /// <summary>
        /// データの種類です。
        /// </summary>
        virtual public DataType DataType
        {
            get { return DataType.None; }
        }

        /// <summary>
        /// データの検証結果です。
        /// </summary>
        virtual public bool Validate
        {
            get
            {
                return true;
            }
        }

        /// <summary>
        /// データモデルを比較します。
        /// </summary>
        virtual public bool Equals(DataModelBase dataModel)
        {
            return true;
        }

        /// <summary>
        /// データモデルを複製します。
        /// </summary>
        virtual public DataModelBase Clone()
        {
            DataModelBase newDataModel = new DataModelBase();

            return newDataModel;
        }

        /// <summary>
        /// データモデルをコピーします。
        /// </summary>
        virtual public bool CopyParam(DataModelBase dataModel, bool copyChild)
        {
            return false;
        }

        /// <summary>
        /// 子ノードとして追加可能かどうかを返します。
        /// </summary>
        virtual public bool CanAddChild(DataModelBase dataModel)
        {
            return false;
        }

        /// <summary>
        /// 表示名です。
        /// </summary>
        override public string ToString()
        {
            return "";
        }
    }
}
