﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace NW4F.LayoutBinaryConverter
{
    // GFX ShaderConverter のバリエーションファイルに準拠したデータ構造
    public class GfxShaderVariation
    {
        public class ShaderVariationDefinitionClass
        {
            public class PreprocessorDefinitionDefinitionArrayClass
            {
                public class PreprocessorDefinitionDefinitionClass
                {
                    [XmlAttributeAttribute()]
                    public int index;

                    [XmlAttributeAttribute()]
                    public string name;
                };
                [XmlElementAttribute("PreprocessorDefinitionDefinition")]
                public PreprocessorDefinitionDefinitionClass[] PreprocessorDefinitionDefinition;

                [XmlAttributeAttribute()]
                public int length;
            };

            public class VariationConstantBufferClass
            {
                [XmlAttributeAttribute()]
                public string name;
            }

            public class VariationConstantDefinitionArrayClass
            {
                public class VariationConstantDefinitionClass
                {
                    [XmlAttributeAttribute()]
                    public int index;

                    [XmlAttributeAttribute()]
                    public string name;

                    [XmlAttributeAttribute()]
                    public string type;
                }
                [XmlElementAttribute("VariationConstantDefinition")]
                public VariationConstantDefinitionClass[] VariationConstantDefinition;

                [XmlAttributeAttribute()]
                public int length;
            }

            public class VertexShaderVariationDefinitionClass
            {
                public PreprocessorDefinitionDefinitionArrayClass PreprocessorDefinitionDefinitionArray;
            }
            public VertexShaderVariationDefinitionClass VertexShaderVariationDefinition;

            public class PixelShaderVariationDefinitionClass
            {
                public PreprocessorDefinitionDefinitionArrayClass PreprocessorDefinitionDefinitionArray;
                public VariationConstantBufferClass VariationConstantBuffer;
                public VariationConstantDefinitionArrayClass VariationConstantDefinitionArray;
            }
            public PixelShaderVariationDefinitionClass PixelShaderVariationDefinition;
        }
        public ShaderVariationDefinitionClass ShaderVariationDefinition;

        public class ShaderVariationValueArrayClass
        {
            public class ShaderVariationValueClass
            {
                public class PreprocessorDefinitionValueArrayClass
                {
                    public class PreprocessorDefinitionValueClass
                    {
                        [XmlAttributeAttribute()]
                        public int index;

                        [XmlText]
                        public int value;
                    }

                    [XmlElementAttribute("PreprocessorDefinitionValue")]
                    public PreprocessorDefinitionValueClass[] PreprocessorDefinitionValue;

                    [XmlAttributeAttribute()]
                    public int length;
                }

                public class VariationConstantValueArrayClass
                {
                    public class VariationConstantValueClass
                    {
                        [XmlAttributeAttribute()]
                        public int index;

                        [XmlText]
                        public string value;
                    }

                    [XmlElementAttribute("VariationConstantValue")]
                    public VariationConstantValueClass[] VariationConstantValueArray;

                    [XmlAttributeAttribute()]
                    public int length;
                }

                public class VertexShaderVariationValueClass
                {
                    public PreprocessorDefinitionValueArrayClass PreprocessorDefinitionValueArray;
                }
                public VertexShaderVariationValueClass VertexShaderVariationValue;

                public class PixelShaderVariationValueClass
                {
                    public PreprocessorDefinitionValueArrayClass PreprocessorDefinitionValueArray;
                    public VariationConstantValueArrayClass VariationConstantValueArray;
                }
                public PixelShaderVariationValueClass PixelShaderVariationValue;

                [XmlAttributeAttribute()]
                public int index;
            }
            [XmlElementAttribute("ShaderVariationValue")]
            public ShaderVariationValueClass[] ShaderVariationValue;

            [XmlAttributeAttribute()]
            public int length;
        }
        public ShaderVariationValueArrayClass ShaderVariationValueArray;

        [XmlAttributeAttribute()]
        public string version;
    }
}
