﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//! @brief 動画をテクスチャに変換する関数
//!
//! @param[out] pFrameCount             出力したフレーム数
//! @param[out] pWidth                  出力画像の幅
//! @param[out] pHeight                 出力画像の高さ
//! @param[in] pInputFileName           入力する動画のファイル名
//! @param[in] pOutputDirName           出力する画像を格納するフォルダ名
//! @param[in] pTextureNamePrefix       テクスチャ名に付加する接頭辞
//! @param[in] beginFrame               動画をデコードする開始フレーム
//! @param[in] endFrame                 動画をデコードする終了フレーム
//! @param[in] alpha                    アルファ付き動画として読み込むかどうか
//! @param[in] paddingNum               連番の桁数
//! @param[in] underscoreEnabled        アンダースコアの有無
//!
//! @return 正常なら 0、エラーなら 0 以外を返す
//!
extern "C" __declspec(dllexport) int ConvertMovieToTexture(
    int* pFrameCount,
    int* pWidth,
    int* pHeight,
    const wchar_t* pInputFileName,
    const wchar_t* pOutputDirName,
    const wchar_t* pTextureNamePrefix,
    int beginFrame,
    int endFrame,
    bool alpha,
    int paddingNum,
    bool underscoreEnabled);
