﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
// Webで紹介されていた、lnkファイルにアクセスするモジュールを参考に実装しました。
//
// http://www.msjogren.net/dotnet/
//

using System;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Utility
{
    /// <remarks>
    /// ShellLink の .NET ラッパーです。
    /// </remarks>
    public class ShellShortcut
    {
        static IWshRuntimeLibrary.WshShell _WshShell;

        /// <summary>
        /// 静的コンストラクタ
        /// </summary>
        static ShellShortcut()
        {
            _WshShell = new IWshRuntimeLibrary.WshShell();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="linkPath">lnkファイルへのパス</param>
        public ShellShortcut( string linkPath )
        {
            var objShortcut = _WshShell.CreateShortcut(linkPath) as IWshRuntimeLibrary.IWshShortcut;
            this.Path = objShortcut.TargetPath;
        }

        /// <summary>
        /// IDisplosable
        /// </summary>
        public void Dispose()
        {
        }

        /// <value>
        /// ショートカットのターゲットパス
        /// </value>
        public string Path
        {
            get;
            private set;
        }
    }
}
