﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using LayoutEditor.Controls.UI;
using System.Collections.Generic;
using System.Windows.Forms;

namespace LayoutEditor.Plugin
{
    /// <summary>
    /// ボタンプラグインに渡すアプリケーション情報です。
    /// </summary>
    public struct ButtonPluginParam
    {
        /// <summary>
        /// アプリケーションフォームを取得または設定します。
        /// </summary>
        public AppForm AppForm { get; set; }

        /// <summary>
        /// ビューマネージャーを取得または設定します。
        /// </summary>
        public ViewManager ViewManager { get; set; }
    };

    /// <summary>
    /// ボタンプラグインのベースクラスです。
    /// </summary>
    public abstract class ButtonPluginBase
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ButtonPluginBase()
        {
        }

        /// <summary>
        /// ボタンプラグインを初期化します。
        /// </summary>
        /// <param name="appInfo">アプリケーション情報</param>
        /// <returns>初期化に成功したときtrueを返します。</returns>
        public virtual bool Initialize(ButtonPluginParam appInfo)
        {
            this.AppInfo = appInfo;

            return true;
        }

        /// <summary>
        /// ツールバーに追加するボタンを列挙します。
        /// </summary>
        public abstract IEnumerable<ToolStripItem> EnumerateButtons();

        /// <summary>
        /// アプリケーション情報を取得します。
        /// </summary>
        public virtual ButtonPluginParam AppInfo { get; private set; }
    }
}
